unit DS1820_Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls, ExtCtrls, Menus, Inifiles;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    MPort: TMenuItem;
    MCOM1: TMenuItem;
    MCOM2: TMenuItem;
    MCOM3: TMenuItem;
    MCOM4: TMenuItem;
    Panel1: TPanel;
    N1: TMenuItem;
    MClosePort: TMenuItem;
    MHelp: TMenuItem;
    MAbout: TMenuItem;
    Panel3: TPanel;
    Label4: TLabel;
    Panel2: TPanel;
    TEd4: TLabel;
    TEd3: TLabel;
    TEd1: TLabel;
    TEd2: TLabel;
    N3: TMenuItem;
    MExit: TMenuItem;
    TEd0: TLabel;
    Label2: TLabel;
    EID: TEdit;
    Label3: TLabel;
    EName: TEdit;
    N2: TMenuItem;
    MCircuit: TMenuItem;
    Label5: TLabel;
    ESNum: TEdit;
    Label6: TLabel;
    ECRC: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    EUsr1: TEdit;
    EUsr2: TEdit;
    StartB: TSpeedButton;
    ExitB: TButton;
    MUtilites: TMenuItem;
    MWrUsrBytes: TMenuItem;
    Timer1: TTimer;
    UpDown1: TUpDown;
    UpDown2: TUpDown;
    MRdROM: TMenuItem;
    N4: TMenuItem;
    MStart: TMenuItem;
    N5: TMenuItem;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MCOM1Click(Sender: TObject);
    procedure MClosePortClick(Sender: TObject);
    procedure MExitClick(Sender: TObject);
    procedure StartBClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure MWrUsrBytesClick(Sender: TObject);
    procedure MAboutClick(Sender: TObject);
    procedure EUsr1Exit(Sender: TObject);
    procedure EUsr1KeyPress(Sender: TObject; var Key: Char);
    procedure EUsr2Exit(Sender: TObject);
    procedure EUsr2KeyPress(Sender: TObject; var Key: Char);
    procedure MCircuitClick(Sender: TObject);
    procedure MRdROMClick(Sender: TObject);
    procedure UpDown1Click(Sender: TObject; Button: TUDBtnType);
    procedure UpDown2Click(Sender: TObject; Button: TUDBtnType);
    procedure MStartClick(Sender: TObject);
  private
    { Private declarations }
    procedure AppMessage(var Msg: TMsg; var Handled: Boolean);
    function  ReadParams:Boolean;
    procedure PClear;
    procedure Open_COM(n:Integer);
    procedure DisableControls;
    procedure ReadConfig;
    procedure SaveConfig;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;
  Ux1,Ux2,Usr1,Usr2,B1,B2: Byte;

  function HConvert(E:TEdit; var H:Byte):Boolean;

implementation

uses DS1820_Sch;

{$R *.DFM}

Const
//  ResBR=10473;   //Reset Baud Rate (non-standard, to speed up)
  ResBR=9600;    //Reset Baud Rate
  SltBR=115200;  //Time slot Baud Rate

var
  WM_COMChange: DWord;
  UsedCOM, InitCOM: Integer;
  Ph,CRC: Byte;
  Present: Boolean;
  CurrentPath: String;

function AccessCOM(P:PChar):boolean;
 stdcall; external 'comapi32.dll';
function OpenCOM(P:PChar):boolean;
 stdcall; external 'comapi32.dll';
function CloseCOM:boolean;
 stdcall; external 'comapi32.dll';
function SetCOM(baud:DWORD;
                bsize,parity,
                sbits:BYTE):boolean;
 stdcall; external 'comapi32.dll';
function SetModCOM(baud:DWORD;bsize,parity,
                sbits:BYTE;DTR,
                RTS:boolean):boolean;
 stdcall; external 'comapi32.dll';
function SetCOMTo(RdIvl,RdTotM,RdTotC,
          WrTotM,WrTotC:DWORD):boolean;
 stdcall; external 'comapi32.dll';
function SetCOMBuff(RdBuff,
                    WrBuff:DWORD):boolean;
 stdcall; external 'comapi32.dll';
function EscFuncCOM(F:DWORD):boolean;
 stdcall; external 'comapi32.dll';
function GetModem(var lpD:DWORD):boolean;
 stdcall; external 'comapi32.dll';
function PurgeCOM:boolean;
 stdcall; external 'comapi32.dll';
function FlushCOM:boolean;
 stdcall; external 'comapi32.dll';
function TxByteCOM(data:byte):boolean;
 stdcall; external 'comapi32.dll';
function TxDataCOM(const Buffer; N:DWORD;
                   var lpNDone:DWORD):boolean;
 stdcall; external 'comapi32.dll';
function RxDataCOM(var Buffer; N:DWORD;
                   var lpNDone:DWORD):boolean;
 stdcall; external 'comapi32.dll';
function ClrErrCOM(var lpE:DWORD):boolean;
 stdcall; external 'comapi32.dll';

//--------------Open COM-------------

procedure TMainForm.Open_COM(n:Integer);
var i: Integer;
begin
 CloseCom; UsedCOM:=0;
 PostMessage(HWND_BROADCAST,WM_COMChange,0,0);
 for i:=1 to 4 do MainMenu1.Items[0].Items[i-1].Checked:=false;
 DisableControls;
 if n=0 then exit;
 if OpenCom(PChar('COM'+Chr(n+$30)))
  then
   begin
    UsedCOM:=n;
    MainMenu1.Items[0].Items[n-1].Checked:=true;
    MClosePort.Enabled:=true;
    PostMessage(HWND_BROADCAST,WM_COMChange,0,0);
    Caption:=Application.Title+' on COM'+Chr(n+$30);
    SetCOMTo(MAXDWORD,0,0,0,0);
    StartB.Enabled:=true;
    MRdROM.Enabled:=true;
    MStart.Enabled:=true;
    Screen.Cursor:=crHourGlass;
    if not ReadParams
     then
      begin
       Screen.Cursor:=crDefault;
       MessageDlg('Device is not found on COM'+Chr(n+$30)+'.',
                mtError,[mbOk],0);
       PClear;
      end;
    Screen.Cursor:=crDefault;
   end
  else
    MessageDlg('Port COM'+Chr(n+$30)+' is not available.',
                mtError,[mbOk],0);
end;

procedure TMainForm.DisableControls;
begin
 Timer1.Enabled:=false;
 StartB.Enabled:=false;
 StartB.Down:=false;
 UpDOwn1.Enabled:=false;
 UpDOwn2.Enabled:=false;
 EUsr1.Enabled:=false;
 EUsr2.Enabled:=false;
 MClosePort.Enabled:=false;
 MRdROM.Enabled:=false;
 MStart.Enabled:=false;
 MWrUsrBytes.Enabled:=false;
 Caption:=Application.Title;
end;

//--------------Init----------------

procedure TMainForm.FormShow(Sender: TObject);
var n: Integer;
begin
 CurrentPath:=ExtractFilePath(ParamStr(0));
 WM_COMChange:=RegisterWindowMessage('COM_Change');
 Application.OnMessage:=AppMessage;
 Caption:=Application.Title;
 ReadConfig;
 for n:=1 to 4 do
   MainMenu1.Items[0].Items[n-1].Enabled:=
        AccessCom(PChar('COM'+Chr(n+$30)));
 Ux1:=$8C; Ux2:=$8C;
 Present:=false; PClear;
 Open_COM(InitCOM);
end;

//--------------Exit-----------------

procedure TMainForm.MExitClick(Sender: TObject);
begin
 Close;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 Timer1.Enabled:=False;
 InitCOM:=UsedCOM;
 SaveConfig;
 CloseCOM; UsedCOM:=0;
 PostMessage(HWND_BROADCAST,WM_COMChange,0,0);
end;

//----------Look for COM change--------


procedure TMainForm.AppMessage(var Msg: TMsg; var Handled: Boolean);
var n: Integer;
begin
  if Msg.message = WM_COMChange then
  begin
   for n:=1 to 4 do
    if UsedCOM<>n then
     MainMenu1.Items[0].Items[n-1].Enabled:=
       AccessCom(PChar('COM'+Chr(n+$30)));
  end;
end;

//--------------Menu "Port"-----------------

//Menu "Port Open"

procedure TMainForm.MCOM1Click(Sender: TObject);
var n:Integer;
begin
 n:=0;
 if Sender=MainMenu1.Items[0].Items[0] then n:=1;
 if Sender=MainMenu1.Items[0].Items[1] then n:=2;
 if Sender=MainMenu1.Items[0].Items[2] then n:=3;
 if Sender=MainMenu1.Items[0].Items[3] then n:=4;
 if UsedCOM<>n
  then Open_COM(n);
end;

//Menu "Port Close"

procedure TMainForm.MClosePortClick(Sender: TObject);
var i:Integer;
begin
 CloseCom; UsedCOM:=0;
 PostMessage(HWND_BROADCAST,WM_COMChange,0,0);
 for i:=1 to 4 do MainMenu1.Items[0].Items[i-1].Checked:=false;
 DisableControls;
 PClear;
end;

//----------1-Wire I/O----------------------;


//TouchReset:

function TReset:Boolean;
var
 B:Byte;
 D,time:DWord;
begin
 Result:=False;
 SetModCom(ResBR,8,NOPARITY,ONESTOPBIT,true,false);
 PurgeCom;
 TxByteCOM($F0);
 time:=GetTickCount+50;
 repeat RxDataCOM(B,1,D)
  until (D=1) or (time<GetTickCount);
 if D=1
  then Result:=(B<>$F0);
 Present:=Result;
end;

//TouchByte:

function TByte(X:Byte):Byte;
var
 n:Integer;
 B:Byte;
 D,time:DWord;
begin
 Result:=$FF;
 SetModCom(SltBR,8,NOPARITY,ONESTOPBIT,true,false);
 PurgeCom;
 time:=GetTickCount+50;
 for n:=1 to 8 do
  begin
   if Odd(X) then TxByteCOM($FF) else TxByteCOM($00);
   X:=X shr 1;
   repeat RxDataCOM(B,1,D)
   until (D=1) or (time<GetTickCount);
   if D<>1 then exit;
   if Odd(B) then X:=X or $80;
   if Odd(B xor CRC)
    then CRC:=((CRC xor $18) shr 1) or $80
    else CRC:=CRC shr 1;
  end;
  Result:=X;
end;

//Clear device ID, serial number, user bytes;

procedure TMainForm.PClear;
begin
 EID.Text:=''; EID.Refresh;
 EName.Text:='NO DEVICE';  EName.Refresh;
 ESnum.Text:='';  ESnum.Refresh;
 ECRC.Text:='';  ECRC.Refresh;
 EUsr1.Text:='';  EUsr1.Refresh;
 EUsr2.Text:='';  EUsr2.Refresh;
 TEd0.Caption:='';
 TEd1.Caption:='-';
 TEd2.Caption:='-';
 TEd4.Caption:='-'; Panel3.Refresh;
end;

//Read device ID, serial number, user bytes;

function TMainForm.ReadParams:Boolean;
var
 B0,B3,B4,B5,B6:Byte;
begin
 Result:=false;
 PClear;
 if not TReset then exit;
 Result:=true;
 TByte($33); //Read ROM
 CRC:=0;
 B0:=TByte($FF); B1:=TByte($FF);
 B2:=TByte($FF); B3:=TByte($FF);
 B4:=TByte($FF); B5:=TByte($FF);
 B6:=TByte($FF); TByte($FF);

 EID.Text:=Format('%.2xH',[B0]);
 if B0=$10
  then
   if (B6*256+B5)>=8
    then EName.Text:='DS18S20'
    else EName.Text:='DS1820'
  else EName.Text:='UNKNOWN';
 ESnum.Text:=Format('%.2x%.2x%.2x%.2x%.2x%.2xH',
                    [B6,B5,B4,B3,B2,B1]);
 if CRC=0 then ECRC.Text:='OK' else ECRC.Text:='FAIL';

 if not TReset then exit;
 TByte($CC); //Skip ROM
 TByte($B8); //Recall EEPROM

 if not TReset then exit;
 TByte($CC); //Skip ROM
 TByte($BE); //Read Scratchpad
 TByte($FF); TByte($FF);
 Usr1:=TByte($FF); Usr2:=TByte($FF);
 EUsr1.Text:=Format('%.2xH',[Usr1]);
 EUsr2.Text:=Format('%.2xH',[Usr2]);
 UpDOwn1.Position:=Usr1;
 UpDOwn2.Position:=Usr2;
 UpDown1.Enabled:=true;
 UpDown2.Enabled:=true;
 EUsr1.Enabled:=true;
 EUsr2.Enabled:=true;
 MWrUsrBytes.Enabled:=true;
end;

//Start:

procedure TMainForm.StartBClick(Sender: TObject);
begin
 StartB.Refresh;
 MStart.Checked:=StartB.Down;
 if StartB.Down then begin Ph:=0; Timer1.Enabled:=True; end
                else Timer1.Enabled:=False;
end;

//Timer Event:

procedure TMainForm.Timer1Timer(Sender: TObject);
var TH,TL,CR,CP,K:Byte;
    Minus:Boolean;
    T:Word;
begin
 Ph:=Ph+1;
 case Ph of
    1: if not TReset
        then
         begin
          TEd0.Caption:='';
          TEd1.Caption:='-';
          TEd2.Caption:='-';
          TEd4.Caption:='-';
          Ph:=0;
         end;
    2: begin
        TByte($CC); //Skip ROM
        TByte($44); //Start T Convert
       end;
    5: if (not Present) or (not TReset)
        then
         begin
          TEd0.Caption:='';
          TEd1.Caption:='-';
          TEd2.Caption:='-';
          TEd4.Caption:='-';
          Ph:=0;
         end;
    6: begin
        TByte($CC); //Skip ROM
        TByte($BE); //Read Scratchpad
        TL:=TByte($FF); TH:=TByte($FF);
        TByte($FF); TByte($FF);
        TByte($FF); TByte($FF);
        CR:=TByte($FF); CP:=TByte($FF);

        TL:=TL div 2; Minus:=TH>0;
        if Minus then TL:=TL or $80;
        if Minus then TL:=(not TL)+1;

        T:=TL*10;
        if Minus then T:=(not T)+1;
        T:=T+7;
        K:=(CP div 26)+1; CP:=CP div K; CR:=CR div K;
        if CP=0 then CP:=1;
        CR:=((10*CR) div CP);
        Minus:=Minus or (CR>T);
        T:=T-CR;

        if Minus then T:=(not T)+1;
        if Minus then TEd0.Caption:='-'
                 else TEd0.Caption:='';
        if T>999 then T:=999;
        TH:=T div 100; T:=T mod 100;
        TL:=T div 10; CR:=T mod 10;
        if TH=0 then TEd1.Caption:='' else
        TEd1.Caption:=IntToStr(TH);
        TEd2.Caption:=IntToStr(TL);
        TEd4.Caption:=IntToStr(CR);
        Ph:=0;
       end;
 end;
end;

//Edit User Bytes:

procedure TMainForm.UpDown1Click(Sender: TObject; Button: TUDBtnType);
begin
 Usr1:=UpDOwn1.Position;
 EUsr1.Text:=Format('%.2xH',[Usr1]);
end;

procedure TMainForm.UpDown2Click(Sender: TObject; Button: TUDBtnType);
begin
 Usr2:=UpDOwn2.Position;
 EUsr2.Text:=Format('%.2xH',[Usr2]);
end;

function ConvD(Ch:Char):Integer;
begin
 case Ch of
 '0'..'9': Result:=Ord(Ch)-$30;
 'A'..'F': Result:=Ord(Ch)-$37;
 else Result:=-1;
 end;
end;

function HConvert(E:TEdit; var H:Byte):Boolean;
var Hp:Byte; S:String; Error:Boolean;
begin
 Hp:=H; Result:=true;
 Error:=false;
 S:=UpperCase(E.Text);
 case length(S) of
 1: if ConvD(S[1])>=0 then H:=ConvD(S[1])
                     else Error:=true;
 2: begin
    if ConvD(S[1])>=0 then H:=ConvD(S[1])
                     else Error:=true;
    if S[2]<>'H'
     then if ConvD(S[2])>=0
           then H:=16*H+ConvD(S[2])
           else Error:=true;
    end;
 3: begin
    if ConvD(S[1])>=0 then H:=ConvD(S[1])
                     else Error:=true;
    if ConvD(S[2])>=0 then H:=16*H+ConvD(S[2])
                     else Error:=true;
    if S[3]<>'H' then Error:=true;
    end;
 else Error:=True;
 end;
 if Error
  then
   begin
   MessageBeep(MB_IconError);
   MessageDlg('Invalid HEX value !',mtError,[mbOK],0);
   H:=Hp;
   E.SetFocus; E.SelectAll;
   Result:=false;
   end;
   E.Text:=Format('%.2xH',[H]);
end;

procedure TMainForm.EUsr1Exit(Sender: TObject);
begin
 HConvert(EUsr1,Usr1);
 UpDOwn1.Position:=Usr1;
end;

procedure TMainForm.EUsr1KeyPress(Sender: TObject; var Key: Char);
begin
 if Key=#13 then
  begin
   HConvert(EUsr1,Usr1);
   UpDOwn1.Position:=Usr1;
   Key:=#0;
   EUsr1.SelectAll;
  end;
 if Key=#27 then
  begin
   EUsr1.Text:=Format('%.2xH',[Usr1]);
   Key:=#0;
   EUsr1.SelectAll;
  end;
end;

procedure TMainForm.EUsr2Exit(Sender: TObject);
begin
 HConvert(EUsr2,Usr2);
 UpDOwn2.Position:=Usr2;
end;

procedure TMainForm.EUsr2KeyPress(Sender: TObject; var Key: Char);
begin
 if Key=#13 then
  begin
   HConvert(EUsr2,Usr2);
   UpDOwn2.Position:=Usr2;
   Key:=#0;
   EUsr2.SelectAll;
  end;
 if Key=#27 then
  begin
   EUsr2.Text:=Format('%.2xH',[Usr2]);
   Key:=#0;
   EUsr2.SelectAll;
  end;
end;

//Menu "Read ROM"

procedure TMainForm.MRdROMClick(Sender: TObject);
begin
 Screen.Cursor:=crHourGlass;
 if not ReadParams then begin
  Screen.Cursor:=crDefault;
  MessageDlg('Device is not found on COM'+Chr(UsedCOM+$30)+'.',
            mtError,[mbOk],0);
  PClear;               end;
 Ph:=0;
 Screen.Cursor:=crDefault;
end;

//Menu "Start Conv."

procedure TMainForm.MStartClick(Sender: TObject);
begin
 StartB.Down:=not StartB.Down;
 StartBClick(nil);
end;

//Menu "Write User Bytes"

procedure TMainForm.MWrUsrBytesClick(Sender: TObject);
begin
 if MessageDlg('Write User Bytes To EEPROM ?'
               ,mtConfirmation,[mbYes,mbNo],0) = mrYes
  then
   begin
    Screen.Cursor:=crHourGlass;

    if not TReset
     then
      begin
       Screen.Cursor:=crDefault;
       MessageDlg('Device is not found on COM'+
                 Chr(UsedCOM+$30)+'.',mtError,[mbOk],0);
       PClear;
       exit;
      end;

    TByte($CC); //Skip ROM
    TByte($4E); //Write Scratchpad
    TByte(Usr1);
    TByte(Usr2);

    TReset;
    TByte($CC); //Skip ROM
    TByte($48); //Copy Scratchpad
    Sleep(20);

    TReset;
    TByte($CC); //Skip ROM
    TByte($B8); //Recall EEPROM

    TReset;
    TByte($CC); //Skip ROM
    TByte($BE); //Read Scratchpad
    TByte($FF); TByte($FF);
    Usr1:=TByte($FF); Usr2:=TByte($FF);

    EUsr1.Text:=Format('%.2xH',[Usr1]);
    EUsr2.Text:=Format('%.2xH',[Usr2]);
    Ph:=0;
    Screen.Cursor:=crDefault;
   end;
end;

//Menu "Circuit"

procedure TMainForm.MCircuitClick(Sender: TObject);
begin
 SchForm.ShowModal;
end;

//Menu "About"

procedure TMainForm.MAboutClick(Sender: TObject);
begin
 MessageDlg('DALLAS DS1820 thermometer test program.'+#13+
            'E-mail: wubblick@yahoo.com.'
               ,mtInformation,[mbOk],0);
end;

// ------------.INI file R/W:-------------------

procedure TMainForm.SaveConfig;
var
 RegKey: TIniFile;
begin
 RegKey := TIniFile.Create(CurrentPath+Application.Title+'.INI');
 with RegKey do
  begin
   WriteInteger('General','Left',MainForm.Left);
   WriteInteger('General','Top',MainForm.Top);
   WriteInteger('General','COM port',InitCOM);
   Free;
  end;
end;

procedure TMainForm.ReadConfig;
var
 RegKey: TIniFile;
begin
 RegKey := TIniFile.Create(CurrentPath+Application.Title+'.INI');
 with RegKey do
  begin
   MainForm.Left:=ReadInteger('General','Left',221);
   MainForm.Top :=ReadInteger('General','Top',180);
   InitCOM      :=ReadInteger('General','COM port',2);
   Free;
  end;
end;

end.
