#include <avr/io.h>
#include <avr/interrupt.h>

unsigned char volatile run=0;

SIGNAL(SIG_COMPARATOR)
{
    register unsigned char  mask;
    
    if(run==0)    
	mask=0;
    else 
	mask=0xA; // вимкнути верхні ключі, не чіпати нижні.

    PORTD&=mask;
    
}


SIGNAL(SIG_TIMER0_COMPA)
{
    PORTD=run;
}

SIGNAL(SIG_TIMER1_COMPA)
{
    switch(run)	
    {
	case 0x06:
	    run=0x09;
	    break;
	case 0x09:
	default:
	    if(run)
		    run=0;
	    else
	    {
		if(bit_is_clear(PINA,PA0) || bit_is_clear(PINA,PA1))
		    run=0x06;
	    }
    }	
}


int main(int argc,char **argv)
{
    PORTD=0x00;
    DDRD=0x0F;
    
    // настроїти компаратор
    ACSR=_BV(ACIE) | _BV(ACIS1) | _BV(ACIS0);

    // настроїти таймер
    OCR0A= 125; // на 5 
    TCCR0A= _BV(WGM01); // CTC
    TCCR0B= _BV(CS01) | _BV(CS00);



    OCR1A=31250/2+100; // 1s = 8 000 000 /256 = 31250
    TCCR1B=_BV(WGM12) | _BV(CS12);

    TIMSK=_BV(OCIE0A) | _BV(OCIE1A);
    
    sei();
    
    PORTA=0x03;
    

    for(;;)
    {
/*
	if(bit_is_clear(PINA,PA0))
	{
	    run=0x09;
	}
	else if(bit_is_clear(PINA,PA1))
	{
	    run=0x06;
	}
	else
	{
	    run=0x00;
	} */
    }
    return 0;
}

