/*-----( Import needed libraries )-----*/
#include <dht11.h>
//#include <LiquidCrystal.h>
#include <Wire.h>
#include <LCD.h>
#include <LiquidCrystal_I2C.h>
#include <OneWire.h>
#include <DallasTemperature.h>
#include <Adafruit_BMP085.h>
#include <RealTimeClockDS1307.h>

#include "Definitions.h"

byte degreeCelsius[8] = {
	B01000,
	B10100,
	B01000,
	B00011,
	B00100,
	B00100,
	B00011,
	B00000
};
byte aquarium[8] = {
	B00000,
	B00000,
	B10110,
	B01001,
	B10110,
	B00000,
	B00000,
	B11111
};
byte onChar[8] = {
	B00000,
	B00100,
	B01110,
	B11111,
	B11111,
	B01110,
	B00100,
	B00000
};
byte offChar[8] = {
	B00000,
	B00100,
	B01010,
	B10001,
	B10001,
	B01010,
	B00100,
	B00000
};

/*-----( Declare objects )-----*/
// DHT 11 sensor object
dht11 DHT11;

// LCD
LiquidCrystal_I2C lcd(LCDADDR, 2, 1, 0, 4, 5, 6, 7, 3, POSITIVE); // Addr, En, Rw, Rs, d4, d5, d6, d7, backlighpin, polarity
//LiquidCrystal lcd(8, 9, 4, 5, 6, 7);

// Setup a oneWire instance to communicate with any OneWire devices (not just Maxim/Dallas temperature ICs)
OneWire oneWire(ONE_WIRE_BUS);

// Pass our oneWire reference to Dallas Temperature.
DallasTemperature dallasTemp(&oneWire);

// barometer object
Adafruit_BMP085 bmp;

int tempDHT;
int humDHT;
int pressureBMP;
float tempBMP;
// current aqua temp
float tempAqua;
float pH =0;
float ORP = 0;
float EC = 0;
int hours;
int minutes;
boolean heater=false;
boolean fan=false;

void setup()   /*----( SETUP: RUNS ONCE )----*/
{
  Serial.begin(9600);
  Serial.println("Aquarium comtroller PROGRAM ");

//  analogWrite(LCDBACKLIGHT, LCDBRIHTNESS);
  //set pin mode
  pinMode(FANPIN, OUTPUT);
  pinMode(HEATERPIN, OUTPUT);
  // off all at start
  digitalWrite(FANPIN, LOW);
  digitalWrite(HEATERPIN, LOW);

  // set up the LCD's number of columns and rows: 
  lcd.begin(20, 4);
  lcd.display();
  
  dallasTemp.begin(); // IC Default 9 bit. If you have troubles consider upping it 12. Ups the delay giving the IC more time to process the temperature measurement
  dallasTemp.setResolution(DS1820RES);  
  
  bmp.begin();
  
  lcd.createChar(DEGREEC, degreeCelsius);
  lcd.createChar(AQUA, aquarium);
  lcd.createChar(ONCHAR, onChar);
  lcd.createChar(OFFCHAR, offChar);
  
  lcd.setCursor(0,2);
  printPower();

}/*--(end setup )---*/

void loop()   /*----( LOOP: RUNS CONSTANTLY )----*/
{
  Serial.println("\n");

  int chk = DHT11.read(DHT11PIN);

  Serial.print("Read sensor: ");
  switch (chk)
  {
    case 0: Serial.println("OK"); break;
    case -1: Serial.println("Checksum error"); break;
    case -2: Serial.println("Time out error"); break;
    default: Serial.println("Unknown error"); break;
  }
  Serial.print("Requesting temperatures...");
  dallasTemp.requestTemperatures(); // Send the command to get temperatures
  Serial.println("DONE");
  
  RTC.readClock();

  // get sensors
  tempDHT = DHT11.temperature;
  humDHT = DHT11.humidity;
  pressureBMP = bmp.readPressureMMHg();
  tempBMP = bmp.readTemperature();
  tempAqua = dallasTemp.getTempCByIndex(0); // Why "byIndex"? You can have more than one IC on the same bus. 0 refers to the first IC on the wire;
  hours = RTC.getHours();
  minutes = RTC.getMinutes();
  
  lcd.setCursor(0, 0);

  //lcd.print("C=");
  //lcd.print(tempDHT);
  //lcd.print(char(0));

  if (hours<10) lcd.print(0);
  lcd.print(hours);
  lcd.print(":");
  if (minutes<10) lcd.print(0);
  lcd.print(minutes);

  
  lcd.print(" ");
  lcd.print(tempBMP,1);
  lcd.print(char(DEGREEC));

  lcd.print(" ");
  lcd.print(humDHT);
  lcd.print("% ");
  
  lcd.print(pressureBMP);
  lcd.print("m");
  
  
  lcd.setCursor(0, 1);
//  lcd.print(char(AQUA));
  lcd.print(tempAqua, 1);
  lcd.print(char(DEGREEC));
  
  lcd.print(" pH:");
  lcd.print(pH);
  
//  lcd.print(" ORP");
//  lcd.print(ORP);

//  lcd.print(" EC");
//  lcd.print(EC);

  // control switches
  //if (tempAqua < 1) { //dallas error
  //    digitalWrite(HEATERPIN, LOW);
  //    digitalWrite(FANPIN, LOW);
  //    lcd.setCursor(0,2);
  //    lcd.print("Heater OFF FAN OFF Sensor error");
  //}
  
  if (tempAqua < TEMP) {
      digitalWrite(HEATERPIN, HIGH);
      heater=true;
      digitalWrite(FANPIN, LOW);
      fan=false;
      lcd.setCursor(0,2);
      printPower();
  }
  if ((tempAqua > (TEMP + 0.5)) && (tempAqua < (TEMP+1.5))) {
      digitalWrite(HEATERPIN, LOW);
      digitalWrite(FANPIN, LOW);      
      heater=false;
      fan=false;
      lcd.setCursor(0,2);
      printPower();
  } 
  if (tempAqua > (TEMP+2)){
      digitalWrite(HEATERPIN, LOW);
      digitalWrite(FANPIN, HIGH);      
      heater=false;
      fan=true;
      lcd.setCursor(0,2);
      printPower();
  }

  delay(2000);
}/* --(end main loop )-- */

/*-----( Declare User-written Functions )-----*/
//
//Celsius to Fahrenheit conversion
double Fahrenheit(double celsius)
{
	return 1.8 * celsius + 32;
}

//Celsius to Kelvin conversion
double Kelvin(double celsius)
{
	return celsius + 273.15;
}

// dewPoint function NOAA
// reference: http://wahiduddin.net/calc/density_algorithms.htm 
double dewPoint(double celsius, double humidity)
{
	double A0= 373.15/(273.15 + celsius);
	double SUM = -7.90298 * (A0-1);
	SUM += 5.02808 * log10(A0);
	SUM += -1.3816e-7 * (pow(10, (11.344*(1-1/A0)))-1) ;
	SUM += 8.1328e-3 * (pow(10,(-3.49149*(A0-1)))-1) ;
	SUM += log10(1013.246);
	double VP = pow(10, SUM-3) * humidity;
	double T = log(VP/0.61078);   // temp var
	return (241.88 * T) / (17.558-T);
}

// delta max = 0.6544 wrt dewPoint()
// 5x faster than dewPoint()
// reference: http://en.wikipedia.org/wiki/Dew_point
double dewPointFast(double celsius, double humidity)
{
	double a = 17.271;
	double b = 237.7;
	double temp = (a * celsius) / (b + celsius) + log(humidity/100);
	double Td = (b * temp) / (a - temp);
	return Td;
}

char* tempToAscii(double temp)
{
  char ascii[32];
  int frac;
  frac=(unsigned int)(temp*10)%10;  //get two numbers to the right of the deciaml point

  itoa((int)temp,ascii,10);
  strcat(ascii,".");
  itoa(frac,&ascii[strlen(ascii)],10); //put the frac after the deciaml
//Serial.print("Converted:");
//Serial.println(ascii);
  return ascii;
}
void printPower(void)
{
  lcd.print("Heater:");
  lcd.print(heater?char(ONCHAR):char(OFFCHAR));
  lcd.print(" Fan:");
  lcd.print(fan?char(ONCHAR):char(OFFCHAR));
}
  
/* ( THE END ) */




