#include <avr/io.h>
# define F_CPU 7372800UL
#include <util/delay.h>
#include <avr/interrupt.h>


uint8_t state_reg = 0;
uint8_t var = 0;
uint8_t data_received = 0;
uint8_t rec_index = 0;
uint8_t recBuffer[4] = {0,0,0,0};

//*****************************************************************************************************************//
uint8_t calc_checksum()
{
        uint8_t checksum = 0;
        checksum+=recBuffer[0];
        checksum+=recBuffer[1];
        checksum+=recBuffer[2];
        return checksum;
}
//*****************************************************************************************************************//
void checkData(void){
	if((recBuffer[0] == 0x21) && (recBuffer[1] == 0xE1) && (recBuffer[3]==calc_checksum())){
		PORTB = recBuffer[2];
		TCNT1 = 0;
	}
}
//*****************************************************************************************************************//
int main(void){

        cli();

        DDRB = 0xFF;
        PORTB = 0x00;

        DDRD = 0x00;
        PORTD = 0x00;

        UCSRA=0x00;
        UCSRB=0x90;
        UCSRC=0x06;
        UBRRH=0x00;
        UBRRL=0x03;

        ACSR=0x80;
        DIDR=0x00;


        TCCR1A=0x00;
        TCCR1B=0x03;
        TCNT1H=0x00;
        TCNT1L=0x00;
        ICR1H=0x00;
        ICR1L=0x00;
        OCR1AH=0x00;
        OCR1AL=0x00;
        OCR1BH=0x00;
        OCR1BL=0x00;

        TIMSK=0x80;

        sei();

        for(;;){
        	if(data_received){
        		recBuffer[0] = recBuffer[1];
        		recBuffer[1] = recBuffer[2];
        		recBuffer[2] = recBuffer[3];
        		recBuffer[3] = var;
        		var = 0;
        		checkData();

        		data_received = 0;
        	}


        	_delay_us(10);
        	 __asm__ __volatile__ ("wdr");
        }

        return 0;
}
//*****************************************************************************************************************//
SIGNAL(SIG_USART0_RECV){

	var = UDR;
	data_received = 1;

}
//*****************************************************************************************************************//
SIGNAL(SIG_TIMER1_OVF){
	PORTB = 0;
}
//*****************************************************************************************************************//

