#include <avr/io.h>
# define F_CPU 7372800UL

#include <util/delay.h>
#include <avr/interrupt.h>

uint8_t state_reg = 0;
uint8_t trans_index = 0;
//*****************************************************************************************************************//
uint8_t calc_checksum(uint8_t narg)
{
        uint8_t checksum = 0;
        checksum+=0x21;
        checksum+=0xE1;
        checksum+=narg;
        return checksum;
}
//*****************************************************************************************************************//
void transmit_data(){

	trans_index = 1;
	UDR = 0x21;
	while ( !( UCSRA & (1<<UDRE)) ){
	}
	UDR = 0xE1;
	while ( !( UCSRA & (1<<UDRE)) ){
	}
	UDR = state_reg;
	while ( !( UCSRA & (1<<UDRE)) ){
	}
	UDR=calc_checksum(state_reg);
	while ( !( UCSRA & (1<<UDRE)) ){
	}
}
//*****************************************************************************************************************//
void checkButton(void){
	state_reg = PINB;
	transmit_data();
}
//*****************************************************************************************************************//
int main(void){

	cli();

	DDRB = 0x00;
	PORTB = 0xFF;

	DDRD = 0xFF;
	UCSRA=0x00;
	UCSRB=0x48;
	UCSRC=0x06;
	UBRRH=0x00;
	UBRRL=0x03;



	checkButton();
	for(;;){
		checkButton();
		_delay_us(10);
		 __asm__ __volatile__ ("wdr");
	}
	return 0;
}
//*****************************************************************************************************************//



