;Labels
;	Crystal Frequency
;	Baud Rate
;	RS232 Control bytes
;	RS232 Control byte bits
;	LCD Control
;	UART Values
;	ADC Values
;	FIFO Values
;	Register Naming
;	Ticker_Flags Bits
;	Immediate_Flags Bits

;Crystal frequency
.equ Osc_Freq = 8000000 ;Hz

;Baud Rate
.equ Baud_Rate = 38400

;RS232 Control bytes

.equ LCDC = 0xFE

.equ DC1 = 0x11
.equ DC2 = 0x12
.equ DC3 = 0x13
.equ DC4 = 0x14

.equ ETB = 0x17

;RS232 Control byte bits

;DC1,B0
.equ BKL = 0
.equ R_W = 1
.equ VD0 = 2
.equ VD1 = 3
.equ VDM = 4
.equ SSP = 5
.equ SDS = 6
.equ SAS = 7

;DC1,B1
.equ M0 = 0
.equ M1 = 1
.equ M2 = 2
.equ M3 = 3
.equ N0 = 4
.equ N1 = 5
.equ N2 = 6
.equ N3 = 7

;DC2
.equ KPC = 0
.equ SPV = 1
.equ SAV = 2
.equ AVM = 3
.equ MC0 = 4
.equ MC1 = 5
.equ MC2 = 6
.equ MC3 = 7

;DC3
.equ KON = 0
.equ SK0 = 1
.equ SK1 = 2

;DC4
.equ GPO0 = 0
.equ GPO1 = 1
.equ GPO2 = 2
.equ INDC = 3
.equ IND0 = 4
.equ IND1 = 5
.equ IND2 = 6
.equ IND3 = 7

;LCD Control
.equ LCD_Port = PORTC
.equ LCD_BKL = 0
.equ LCD_RS = 1
.equ LCD_RW = 2
.equ LCD_E = 3

.equ LCD_Delay_4100_Val=((4100*(Osc_Freq/1000000))/4)-4)
.equ LCD_Delay_160_Val=((160*(Osc_Freq/1000000))/4)-4)

.equ LCD_Bar_On = 0xDB	;Bargraph on character = hollow box
.equ LCD_Bar_Off = '-'	;Bargraph off character = -

.equ LCD_Separator = ' ';LCD name separator = space


;UART Values
.equ UBRR_Val = (Osc_Freq/(16*Baud_Rate)) - 1

;ADC Values
.if (Osc_Freq/2)<250000)
	.equ ADC_Prescale_Val=0x01

	.elif(Osc_Freq/4)<250000)
	.equ ADC_Prescale_Val=0x02

	.elif(Osc_Freq/8)<250000)
	.equ ADC_Prescale_Val=0x03

	.elif(Osc_Freq/16)<250000)
	.equ ADC_Prescale_Val=0x04

	.elif(Osc_Freq/32)<250000)
	.equ ADC_Prescale_Val=0x05

	.elif(Osc_Freq/64)<250000)
	.equ ADC_Prescale_Val=0x06

	.elif(Osc_Freq/128)<250000)
	.equ ADC_Prescale_Val=0x07

	.else
	.equ ADC_Prescale_Val=0x00
	.error "ADC_Prescale_Val could not be determined."

.endif


;FIFO Values
.equ LCD_FIFO_Size = 96
.equ Keypad_FIFO_Size = 32
.equ EEPROM_FIFO_Size = 96
.equ USART_RX_FIFO_Size = 16
.equ USART_TX_FIFO_Size = 64

;Register Naming
.def DC1_B0 = r2
.def DC2_B0 = r3
.def DC3_B0 = r4
.def DC4_B0 = r5

.def Ticker_Val = r6
.def Ticker_Flags = r7

.def Keypad_C0L = r8
.def Keypad_C0H = r9
.def LCD_C0 = r10
.def LCD_C1L = r11
.def LCD_C1H = r12

.def Immediate_Flags = r13

;Ticker_Flags Bits
.equ Update_Keypad = 0
.equ Update_LCD0 = 1
.equ Update_LCD1 = 2
.equ Test_Keypad = 4
.equ Test_LCD0 = 5
.equ Test_LCD1 = 6

;Immediate_Flags Bits
.equ Test_RX_FIFO = 0
.equ Test_TX_FIFO = 1
.equ Test_EEPROM_FIFO = 2

;LCD1 Flags
.equ Disp_ADC = 0





