// Аналоговые входы (analog pins) могут быть использованы как цифровые вход/выходы (digital pins). 
// Обращение к ним идет по номерам от 14 (для аналогового входа 0) до 19 (для аналогового входа 5).
#define EXT_FILTER_PIN 12
#define EXT_AIR_PIN 1  
#define EXT_HEATER_PIN 13  
#define EXT_COOLING_PIN 10  
#define EXT_LIGHT_1_PIN 15
#define EXT_LIGHT_2_PIN 16
#define EXT_CO2_PIN 0  

#define EXT_POWER_ON_PIN 20
#define EXT_LIGHT_LED_PIN 11

#define EXT_UDO_MICRO_PIN 17
#define EXT_UDO_MACRO_PIN 18
#define EXT_UDO_Fe_PIN 19

#define Key_PIN 7

#define DispLight_min 253  //минимальная подсветка в режиме часов
const int CorrTime = -23;      // коррекция хода системных часов [Сек]  
// It is assumed that the LCD module is connected to
// the following pins using a levelshifter to get the
// correct voltage to the module.
//      SCK  - Pin 8
//      MOSI - Pin 9
//      DC   - Pin 10
//      RST  - Pin 11
//      CS   - Pin 12
//
#include <LCD5110_Graph.h>

#define LED_LIGHT_PIN 9  
LCD5110 myGLCD(8,7,6,4,5); 
extern uint8_t SmallFont[];
extern uint8_t BigNumbers[];
//extern unsigned char TinyFont[];
byte ledContrast = 65;
byte ledLight = 220;

//подключаем заголовочный файл библиотеки EEPROM
#include <EEPROM.h>

#include <OneWire.h> 
OneWire  temp(14);  // on pin 10 (a 4.7K resistor is necessary) 
float cur_temp = -999;
byte temp_type_s;
byte temp_data[12];
byte temp_addr[8];
byte temp_cicle = 0;
// I assume you know how to connect the DS1307.
// DS1307:  SDA pin   -> Arduino Digital 4
//          SCL pin   -> Arduino Digital 5

#include <DS1307.h>

// Init the DS1307
DS1307 rtc(3, 2); 
// Init a Time-data structure
Time  time; 
unsigned long currentTime;
unsigned long loopTime;


byte key = 0;
byte prev_key = 0;
int idle_key = 0;
const int max_idle_key = 100; //цыклов не активности перед скринсейвером

int cur_menu = 0;
int cur_item = 0;
boolean cur_item_edit = false;
byte aquaT;                   // Требуемая температура воды
boolean CoolingEnabled = false;             // Разрешено ли охлаждение куллером
boolean light1 = false;
boolean light2 = false;
boolean air = false;
boolean CO2 = false;
byte kormMin = 0;             // Остаток времени для кормления мин
byte prevMin = 0;             

byte minCool = 0;  // минимальные обороты кулера для вентиляции крышки и охлаждения ламп
byte maxCool = 0;  // максимальные обороты для охлаждения воды

void setup()
{
  pinMode(EXT_HEATER_PIN, OUTPUT);      // устанавливает режим работы - выход
  digitalWrite(EXT_HEATER_PIN, LOW);   // выключает
  pinMode(EXT_COOLING_PIN, OUTPUT);      // устанавливает режим работы - выход
  digitalWrite(EXT_COOLING_PIN, LOW);   // выключает
  pinMode(EXT_LIGHT_1_PIN, OUTPUT);      // устанавливает режим работы - выход
  digitalWrite(EXT_LIGHT_1_PIN, HIGH);   // выключает
  light1 = true;
  pinMode(EXT_LIGHT_2_PIN, OUTPUT);      // устанавливает режим работы - выход
  digitalWrite(EXT_LIGHT_2_PIN, LOW);   // выключает
  light2 = false;
  pinMode(EXT_FILTER_PIN, OUTPUT);      // устанавливает режим работы - выход
  digitalWrite(EXT_FILTER_PIN, HIGH);   // выключает
  pinMode(EXT_CO2_PIN, OUTPUT);      // устанавливает режим работы - выход
  digitalWrite(EXT_CO2_PIN, LOW);   // выключает
  CO2 = false;
  pinMode(EXT_AIR_PIN, OUTPUT);      // устанавливает режим работы - выход
  digitalWrite(EXT_AIR_PIN, HIGH);   // выключает
  air = true;
  CoolingEnabled = false;             // Разрешено ли охлаждение куллером


  pinMode(EXT_POWER_ON_PIN, OUTPUT);      // устанавливает режим работы - выход
  digitalWrite(EXT_POWER_ON_PIN, LOW);   // выключает
  pinMode(EXT_LIGHT_LED_PIN, OUTPUT);      // устанавливает режим работы - выход
  digitalWrite(EXT_LIGHT_LED_PIN, LOW);   // выключает
  pinMode(EXT_UDO_MICRO_PIN, OUTPUT);      // устанавливает режим работы - выход
  digitalWrite(EXT_UDO_MICRO_PIN, LOW);   // выключает
  pinMode(EXT_UDO_MACRO_PIN, OUTPUT);      // устанавливает режим работы - выход
  digitalWrite(EXT_UDO_MACRO_PIN, LOW);   // выключает
  pinMode(EXT_UDO_Fe_PIN, OUTPUT);      // устанавливает режим работы - выход
  digitalWrite(EXT_UDO_Fe_PIN, LOW);   // выключает

  //включит pullup резистор для входа:
//  pinMode(Key_PIN, INPUT);

// Init EEPROM
//  for(int e = 0; e < 2047; e++) EEPROM.write(e,0);
//  EEPROM.write(0,61);   // ledContrast  !!!!!!! Очень акуратно иначе белый либо черный экран
//  EEPROM.write(1,200);  // ledLight 
//  EEPROM.write(2,24);   // Требуемая температура воды
//  EEPROM.write(3,1);    // Разрешено ли охлаждение куллером
  
  ledContrast = EEPROM.read(0);
  // первичная установка контраста - иначе при первом запуске нихрена невидно
  if ((ledContrast==0)||(ledContrast==255)){
    ledContrast = 65;
  }

  ledLight = EEPROM.read(1);
  myGLCD.InitLCD(ledContrast);
  pinMode(LED_LIGHT_PIN, OUTPUT);      // устанавливает режим работы - выход
  analogWrite(LED_LIGHT_PIN,ledLight);
  aquaT = EEPROM.read(2);                   // Требуемая температура воды

  minCool = EEPROM.read(3);  // минимальные обороты кулера для вентиляции крышки и охлаждения ламп
  maxCool = EEPROM.read(4);  // максимальные обороты для охлаждения воды

  // Set the clock to run-mode
  rtc.halt(false); 
//  rtc.setDOW(SUNDAY);        // Set Day-of-Week to SUNDAY
//  rtc.setTime(12, 0, 0);     // Set the time to 12:00:00 (24hr format)
//  rtc.setDate(3, 10, 2010);   // Set the date to October 3th, 2010 
  
  myGLCD.setFont(SmallFont);
  myGLCD.clrScr();
  myGLCD.print("AQUA controll", CENTER, 3);
  myGLCD.print("ALEX", CENTER, 20);
  myGLCD.drawRect(28, 18, 56, 28);
  for (int i=0; i<6; i++)
  {
    myGLCD.drawLine(57, 18+(i*2), 83-(i*3), 18+(i*2));
    myGLCD.drawLine((i*3), 28-(i*2), 28, 28-(i*2));
  }
//  myGLCD.setFont(TinyFont);
  myGLCD.print("(C) AlexVOK", CENTER, 36);
//  myGLCD.print("AlexVOK@gmail.com", CENTER, 42);
  myGLCD.update();
  delay(1000);

//-------------------------------------------------------------------------------
  byte b = 0;
  while ( (!temp.search(temp_addr))&&(b < 10)) {
    //Serial.println("Нет больше адресов.");
    temp.reset_search();
    delay(250);
    b++;
  }
//  if (OneWire::crc8(temp_addr, 7) != temp_addr[7]) {
//      Serial.println("CRC не является действительным!");
//  }

// Первый байт ROM указывает, какой чип
  switch (temp_addr[0]) {
    case 0x10:
//      Serial.println("  Chip = DS18S20"); 
      temp_type_s = 1;
      break;
    case 0x28:
//      Serial.println("  Chip = DS18B20");
      temp_type_s = 0;
      break;
    case 0x22:
//      Serial.println("  Chip = DS1822");
      temp_type_s = 0;
      break;
//    default:
//      Serial.println("Устройство не распознано");
  }

  currentTime = millis();
  loopTime = currentTime;   
}

//-----------------------------------------------------------------------------------
float getTemp(){
//  temp.reset();
//  temp.select(temp_addr);
//  temp.write(0x44, 1);        // start conversion, with parasite power on at the end
  
//  delay(1000);     // maybe 750ms is enough, maybe not
  // we might do a ds.depower() here, but the reset will take care of it.
  
  temp.reset();
  temp.select(temp_addr);    
  temp.write(0xBE);         // Read Scratchpad

  for (byte i = 0; i < 9; i++) {           // we need 9 bytes
    temp_data[i] = temp.read();
  }
//  Serial.print(OneWire::crc8(data, 8), HEX);

  // Convert the data to actual temperature
  // because the result is a 16 bit signed integer, it should
  // be stored to an "int16_t" type, which is always 16 bits
  // even when compiled on a 32 bit processor.
  int16_t raw = (temp_data[1] << 8) | temp_data[0];
  
  if (temp_type_s) {
    raw = raw << 3; // 9 bit resolution default
    if (temp_data[7] == 0x10) {
      // "count remain" gives full 12 bit resolution
      raw = (raw & 0xFFF0) + 12 - temp_data[6];
    }
  } else {
    byte cfg = (temp_data[4] & 0x60);
    // at lower res, the low bits are undefined, so let's zero them
    if (cfg == 0x00) raw = raw & ~7;  // 9 bit resolution, 93.75 ms
    else if (cfg == 0x20) raw = raw & ~3; // 10 bit res, 187.5 ms
    else if (cfg == 0x40) raw = raw & ~1; // 11 bit res, 375 ms
    //// default is 12 bit resolution, 750 ms conversion time
  }
  return ((float)raw / 16.0);
}

//-----------------------------------------------------------------------------------
// Нажатые кнопки
//int button;
const byte BUTTON_NONE   = 0;
const byte BUTTON_UP     = 1;
const byte BUTTON_DOWN   = 2;
const byte BUTTON_OK     = 3;
const byte BUTTON_CANCEL = 4;

int getPressedButton()
{
 int KeyNum=0;
 int KeyValue1=0;
 int KeyValue2=0;
 
//Читаем в цикле аналоговый вход, для подавления дребезга и нестабильности читаем по два раза подряд, пока значения не будут равны.
//Если значения равны 1023 – значит не была нажата ни  одна клавиша.
do {
 // считываем значения с аналогового входа(A0)  
 KeyValue1=analogRead(Key_PIN);
 delay(10);
 KeyValue2=analogRead(Key_PIN);
 delay(5);
 } while (KeyValue1!=KeyValue2);
 
//Интерпретируем полученное значение и определяем код нажатой клавиши
 if (KeyValue2 > 900) 
  {KeyNum = BUTTON_NONE;}
 else if (KeyValue2 > 450) 
       {KeyNum = BUTTON_CANCEL;}
      else if (KeyValue2 > 250) 
            {KeyNum = BUTTON_UP;}
           else if (KeyValue2 > 100) 
                 {KeyNum = BUTTON_DOWN;}
                else {KeyNum = BUTTON_OK;}
//Возвращаем код нажатой клавиши
return KeyNum;
}

//-----------------------------------------------------------------------------------
void naviKey(byte maxItems){
  if(key == BUTTON_UP){
    cur_item--;
    if(cur_item < 1)
      cur_item = maxItems;
  }
  if(key == BUTTON_DOWN){
    cur_item++;
    if(cur_item > maxItems)
      cur_item = 1;
  }
}
//-----------------------------------------------------------------------------------
void drawMenu(String mName, String item1, String item2, String item3, String item4){
  myGLCD.setFont(SmallFont);
  myGLCD.clrScr();
  
  myGLCD.print(mName,1,0);
  myGLCD.print(rtc.getTimeStr(FORMAT_SHORT),RIGHT,0);
  myGLCD.drawLine(0,8,83,8);
  myGLCD.drawLine(0,9,83,9);

  if(cur_item == 1){
    myGLCD.print(item1,3,12);
    myGLCD.drawRoundRect(0,11,83,20);
  }else  
    myGLCD.print(item1,0,12);
      
  if(cur_item == 2){
    myGLCD.print(item2,3,21);
    myGLCD.drawRoundRect(0,20,83,29);
  }else  
    myGLCD.print(item2,0,21);

  if(cur_item == 3){
    myGLCD.print(item3,3,30);
    myGLCD.drawRoundRect(0,29,83,38);
  }else  
    myGLCD.print(item3,0,30);

  if(cur_item == 4){
    myGLCD.print(item4,3,39);
    myGLCD.drawRoundRect(0,38,83,47);
  }else  
    myGLCD.print(item4,0,39);

  myGLCD.update();
}

byte menu_hh;
byte menu_mi;
byte menu_dd;
byte menu_mm;
int menu_yyyy;
byte menu_dow;
byte menu_off;
byte menu_item_count;
int alertAdr;
byte curLoad = 0;

byte prMin = 0;
//-----------------------------------------------------------------------------------
void drawIntMenu(String mName, int minVal, int maxVal, int Val){
  myGLCD.setFont(SmallFont);
  myGLCD.clrScr();
  
  myGLCD.print(mName,1,0);
//  myGLCD.print(rtc.getTimeStr(FORMAT_SHORT),RIGHT,0);
  myGLCD.drawLine(0,8,83,8);
  myGLCD.drawLine(0,9,83,9);

  myGLCD.setFont(BigNumbers);
  myGLCD.printNumI(Val,CENTER,11);

  myGLCD.drawRoundRect(0,38,83,47);
  
  int k = 80*(Val-minVal)/(maxVal - minVal);
  for(int i = 2; i < k+2; i++)
    myGLCD.drawLine(i,40,i,46);
  myGLCD.update();
}

boolean  new_day = true;
byte secc = 0;
byte LED_sunrise = 0;
byte LED_cur_pos = 0;
byte udo_tim = 0;
//*****************************************************************************************
//*****************************************************************************************
void loop() {
currentTime = millis();
key = getPressedButton();
if((currentTime >= (loopTime + 250))||(key != prev_key)){ // проверяем каждые 5мс (20 Гц)

  if((prev_key != key)&&(key != 0)){
    idle_key = 0;
  }else{ 
    idle_key++;
  }
  prev_key = key;


  if (key == 0) // Измереяем температуру только в состоянии простоя
  {
    if(temp_cicle == 0){
      temp.reset();
      temp.select(temp_addr);
      temp.write(0x44, 1);        // start conversion, with parasite power on at the end
    }
    if(temp_cicle == 4){
      cur_temp = getTemp();
      // Управление нагревом и охлаждением ----------------------------------------------
      if(cur_temp < (float)aquaT){
        digitalWrite(EXT_HEATER_PIN, HIGH);   // включает нагреватель
      }else  
        digitalWrite(EXT_HEATER_PIN, LOW);   // выключает  нагреватель
        
      if (CoolingEnabled) {
        if(cur_temp > ((float)aquaT+0.1)){               // Разрешено ли охлаждение куллером
          int coll_cur = minCool+(((float)(maxCool - minCool))/100)*(((float)(cur_temp-aquaT))/0.5)*100;
          if (coll_cur > maxCool) { coll_cur = maxCool;}
          analogWrite(EXT_COOLING_PIN, coll_cur);   // включает куллер
        }else{  
          analogWrite(EXT_COOLING_PIN, minCool);   // включаем режим проветривания
        }
      }else{
        if (air||light1){
//        if (air||light1||light2){
          analogWrite(EXT_COOLING_PIN, minCool);   // включаем режим проветривания
        }else{  
          digitalWrite(EXT_COOLING_PIN, LOW);   // выключает  куллер
        }
      } 
    }
    if(temp_cicle > 51){
      temp_cicle = 0;
    }else{
      temp_cicle++;
    }
  }

// --------------------------------------------------------------------------------


  if(secc > 4){
    secc = 0;
  }else{
    secc++;
  }

  
  // Get data from the DS1307
  time = rtc.getTime();   
  // коррекция хода системных часов [Сек]  
  if ((time.hour == 0)&&(time.min == 0)){
    new_day = true;
  }
  if ((time.hour == 0)&&(time.min == 30)&&(new_day)){
    int corr_sec = time.sec + CorrTime;    // коррекция хода системных часов [Сек]  
    byte corr_min = time.min + (byte)(corr_sec/60);
    corr_sec = corr_sec - (byte)(corr_sec/60)*60;
    if (corr_sec < 0){
      corr_sec = corr_sec + 60;
      corr_min = corr_min - 1;
    }
    rtc.setTime(time.hour, corr_min, corr_sec);     // Set the time to 12:00:00 (24hr format)
    new_day = false;
  }
  //-----
  // Новая минута ----------------------------------------------
  if(prevMin != time.min){  
    // Время для кормления мин
    if(kormMin > 0){
      digitalWrite(EXT_FILTER_PIN, LOW);   // выключает Фильтр
      kormMin--;
    }else{
      digitalWrite(EXT_FILTER_PIN, HIGH);   // включает Фильтр
    }  
    // Восход / Закат
    if (LED_sunrise > 0){
      byte led_val = (LED_sunrise&B01111111);
      byte led_tmp = 0;
      if (LED_cur_pos > led_val){
        led_tmp = 255;
        LED_sunrise = 0;
      }else{  
        led_tmp = LED_cur_pos*255/led_val;
      } 
      if(LED_sunrise&B10000000){  // Восход
      }else{  // Закат
        led_tmp = 255 - led_tmp;
      }
      // Управляем блоком питания
      if (led_tmp == 0){
        digitalWrite(EXT_POWER_ON_PIN, LOW);
      }else{         
        digitalWrite(EXT_POWER_ON_PIN, HIGH);
      }  

      analogWrite(EXT_LIGHT_LED_PIN, led_tmp);   // LED
      LED_cur_pos++;
    } 
    prevMin = time.min;
  }  
  // -----------------------------------------------------------
  if((idle_key > max_idle_key)&&(cur_menu != 0)){
    cur_menu = 0;
    cur_item = 0;
    cur_item_edit = false;
  }  
    
  switch(cur_menu){
    case 0: // Time
    {
      analogWrite(LED_LIGHT_PIN,DispLight_min);
      myGLCD.setFont(BigNumbers);
      myGLCD.clrScr();
      myGLCD.printNumI(time.hour,7,2,2,'0');
      myGLCD.drawCircle(42,9,3);
      myGLCD.drawCircle(42,19,3);
      if(secc < 2){
        myGLCD.drawCircle(42,9,2);
        myGLCD.drawCircle(42,19,2);
        myGLCD.drawRect(41,8,43,10);
        myGLCD.drawRect(41,18,43,20);
        myGLCD.setPixel(42,9);
        myGLCD.setPixel(42,19);
      }
      myGLCD.printNumI(time.min,49,2,2,'0');
      
      myGLCD.setFont(SmallFont);
      if(cur_temp < 1){
        myGLCD.print("T: Error",3,38);
      }else{
        myGLCD.print("T:",3,38);
        myGLCD.printNumF(cur_temp,2,15,38);
      }
      myGLCD.update();
      if(key > 0)
        cur_menu = 1;      
        cur_item = 0;
        cur_item_edit = false;
        // Включаем подсветку LED
//        analogWrite(LED_LIGHT_PIN,ledLight);
      break;
    }
    case 1: // Main -----------------------------------------------------------------
    {
    analogWrite(LED_LIGHT_PIN,ledLight);
    String ll;
      if(light1||light2){
        ll = "On";
      }else
        ll ="Off";

      String aa;
      if(air){
        aa = "On";
      }else
        aa ="Off";

      if(cur_item_edit&&(cur_item == 1))
        ll = "["+ll+"]";

      if(cur_item_edit&&(cur_item == 2))
        aa = "["+aa+"]";
        
      String lk = "";
      if(kormMin > 0){
        lk = " ("+(String)kormMin+")";
      }  
      drawMenu("Main","Light "+ll,"Air "+aa,"Kormlenie"+lk,"Settings");
      naviKey(4);
      switch(key){
        case BUTTON_OK:
          switch(cur_item){
            case 1:
              light1 = !light1;
              light2 = light1;
              if(light1){
                digitalWrite(EXT_LIGHT_1_PIN, HIGH);  // включает LED
              }else
                digitalWrite(EXT_LIGHT_1_PIN, LOW);   // выключает LED
              if(light2){
                digitalWrite(EXT_LIGHT_2_PIN, HIGH); // включает lightTUBE
              }else
                digitalWrite(EXT_LIGHT_2_PIN, LOW);  // выключает lightTUBE
            break;
            case 2:
              air = !air;
              if(air){
                digitalWrite(EXT_AIR_PIN, HIGH);  // включает
              }else
                digitalWrite(EXT_AIR_PIN, LOW);   // выключает
            break;
            case 3:
              kormMin = 20;
              digitalWrite(EXT_FILTER_PIN, LOW);   // выключает Фильтр
            break;
            case 4:
              cur_menu = 13;      
              cur_item = 0;
            break;
          }
        break;
        case BUTTON_CANCEL:
          cur_item_edit = false;
          cur_menu = 0;
          cur_item = 0;
        break;
      }
      break;
    }
    case 13: // Settings -----------------------------------------------------------------
    {
      drawMenu("Settings", "System","Termostat","Tasker","UDO");
      naviKey(4);
      switch(key){
        case BUTTON_OK:
          switch(cur_item){
            case 1:
              cur_menu = 131;      
              cur_item = 0;
            break;
            case 2:
              cur_menu = 132;      
              cur_item = 0;
            break;
            case 3:
              cur_menu = 130;      
              cur_item = 1;
            break;
            case 4:
              cur_menu = 134;      
              cur_item = 0;
            break;
          }
        break;
        case BUTTON_CANCEL:
          cur_menu = 1;
          cur_item = 3;
        break;
      }
      break;
    }
    case 134: // UDO -----------------------------------------------------------------
    { String uu; 
      if (CO2){
        uu = "On";
      }else{
        uu = "Off";
      }  
      drawMenu("UDO", "CO2", "UDO","CO2 "+uu,"");
      naviKey(3);
      switch(key){
        case BUTTON_OK:
          switch(cur_item){
            case 1:
              cur_menu = 133;      
              cur_item = 1;
              menu_off = 1;
              menu_item_count = 25;
              curLoad = 4;
            break;
            case 2:
              cur_menu = 133;      
              cur_item = 1;
              menu_off = 1;
              menu_item_count = 25;
              curLoad = 6;
            break;
            case 3:
              CO2 = !CO2;
              if (CO2){
                digitalWrite(EXT_CO2_PIN, HIGH);
              }else{
                digitalWrite(EXT_CO2_PIN, LOW);
              }  
            break;
            case 4:
//              cur_menu = 130;      
//              cur_item = 1;
            break;
          }
        break;
        case BUTTON_CANCEL:
          cur_menu = 13;
          cur_item = 4;
        break;
      }
      break;
    }
    case 130: // Tasker -----------------------------------------------------------------
    {
      drawMenu("Tasker","Light 1","Light 2","LED","Air");
      naviKey(4);
      switch(key){
        case BUTTON_OK:
          switch(cur_item){
            case 1:
              cur_menu = 133;      
              cur_item = 1;
              menu_off = 1;
              menu_item_count = 25;
              curLoad = 1;
            break;
            case 2:
              cur_menu = 133;      
              cur_item = 1;
              menu_off = 1;
              menu_item_count = 25;
              curLoad = 2;
            break;
            case 3:
              cur_menu = 133;      
              cur_item = 1;
              menu_off = 1;
              menu_item_count = 25;
              curLoad = 5;
            break;
            case 4:
              cur_menu = 133;      
              cur_item = 1;
              menu_off = 1;
              menu_item_count = 25;
              curLoad = 3;
            break;
        }
        break;
        case BUTTON_CANCEL:
          cur_menu = 13;
          cur_item = 3;
        break;
      }
      break;
    }
    case 133: // Tasker Menu List -----------------------------------------------------------------
    {
      myGLCD.setFont(SmallFont);
      myGLCD.clrScr();
      int offf;
      switch(curLoad){
        case 0:
          myGLCD.print("CoolTime",1,0);
          offf = 400;
        break;
        case 1:
          myGLCD.print("Light 1",1,0);
          offf = 100;
        break;
        case 2:
          myGLCD.print("Light 2",1,0);
          offf = 200;
        break;
        case 3:
          myGLCD.print("Air",1,0);
          offf = 300;
        break;
        case 4:
          myGLCD.print("CO2",1,0);
          offf = 500;
        break;
        case 5:
          myGLCD.print("LED",1,0);
          offf = 600;
        break;
        case 6:
          myGLCD.print("UDO",1,0);
          offf = 700;
        break;
      }

      myGLCD.print(rtc.getTimeStr(FORMAT_SHORT),RIGHT,0);
      myGLCD.drawLine(0,8,83,8);
      myGLCD.drawLine(0,9,83,9);
      
      String tt;
      byte vy;
      for(byte j = menu_off; j <= min(menu_off+3,menu_item_count); j++){
        vy = 3+9*(j-menu_off+1);
        tt = "Time "+(String)(j);
        if(EEPROM.read(offf+(j-1)*4)&B10000000){
          tt = tt+" Active";
        }        
        if(cur_item == j){
          myGLCD.print(tt,3,vy);
          myGLCD.drawRoundRect(0,vy-1,83,vy+8);
        }else  
          myGLCD.print(tt,0,vy);
      }

      switch(key){
        case BUTTON_UP:
          if(cur_item == 1){ 
            cur_item = menu_item_count;
            menu_off = menu_item_count - 3;
          }else{  
            cur_item--;
            if(cur_item < menu_off){
             menu_off = cur_item;
            }
          }  
        break;
        case BUTTON_DOWN:
          if(cur_item == menu_item_count){ 
            cur_item = 1;
            menu_off = 1;
          }else{  
            cur_item++;
            if(cur_item > menu_off+3){
             menu_off = cur_item-3;
            }
          }  
        break;
        case BUTTON_OK:
          alertAdr = offf+(cur_item-1)*4;
          cur_menu = 1330;
          cur_item = 1;
          cur_item_edit = false;
        break;
        case BUTTON_CANCEL:
          switch(curLoad){
           case 0:
             //"CoolTime"
             cur_menu = 132;
             cur_item = 2;
           break;
           case 1:
             //"Light1",
             cur_menu = 130;
             cur_item = 1;
           break;
           case 2:
             //"Light2"
             cur_menu = 130;
             cur_item = 2;
           break;
           case 3:
             //"Air"
             cur_menu = 130;
             cur_item = 4;
           break;
           case 4:
             //"CO2"
             cur_menu = 134;
             cur_item = 1;
           break;
           case 5:
             //"LED"
             cur_menu = 130;
             cur_item = 3;
           break;
           case 6:
             //"UDO"
             cur_menu = 134;
             cur_item = 2;
           break;
        }

          cur_item_edit = false;
        break;
      }
      myGLCD.update();
      break;
    }
    case 1330: // Tasker Menu -----------------------------------------------------------------
    {
      myGLCD.setFont(SmallFont);
      myGLCD.clrScr();
      
      switch(curLoad){
        case 0:
          myGLCD.print("CoolTime",1,0);
        break;
        case 1:
          myGLCD.print("Light1",1,0);
        break;
        case 2:
          myGLCD.print("Light2",1,0);
        break;
        case 3:
          myGLCD.print("Air",1,0);
        break;
        case 4:
          myGLCD.print("CO2",1,0);
        break;
        case 5:
          myGLCD.print("LED",1,0);
        break;
        case 6:
          myGLCD.print("UDO",1,0);
        break;
      }

      myGLCD.print(rtc.getTimeStr(FORMAT_SHORT),RIGHT,0);
      myGLCD.drawLine(0,8,83,8);
      myGLCD.drawLine(0,9,83,9);
      byte b1 = EEPROM.read(alertAdr);
      byte bt = b1;
      myGLCD.print("MoTuWeThFrSaSu",0,11);
      for(int j = 1; j < 8; j++){
//        if((cur_item == j)&cur_item_edit){
        if(cur_item == j){
          myGLCD.drawRect(j*12-10,20,j*12-2,28);
        }  
        myGLCD.drawCircle(j*12-6,24,3);
        if(bt&B00000001){
          myGLCD.drawCircle(j*12-6,24,2);
          myGLCD.drawCircle(j*12-6,24,1);
        }
        bt = bt >> 1;
      }
      String stat = "";
      if(cur_item == 8){
        stat = stat + "[";
      }
      if(EEPROM.read(alertAdr)&B10000000){
        stat = stat + "Act";
      }else
        stat = stat + "Pas";
      if(cur_item == 8){
        stat = stat + "]";
      }

      stat = stat + ".";
      if(cur_item == 9){
        stat = stat + "[";
      }
      byte tmpb = EEPROM.read(alertAdr+3);
      switch(curLoad){
        case 5: // "TimerLED"
          if (tmpb&B10000000){
            stat = stat + "On";
          }else{
            stat = stat + "Off";
          }  
          stat = stat + " " + (tmpb&B01111111)+"min";
        break;
        case 6:  //  "TimerUDO"
          switch((byte)((tmpb>>6)&B00000011)){
            case 0: // Micro
              stat = stat + "Micro";
            break;
            case 1: // Macro
              stat = stat + "Macro";
            break;
            case 2: // Fe+
              stat = stat + "Fe+";
            break;
            case 3: // Ka
              stat = stat + "Ka";
            break;
          }
          stat = stat + (tmpb&B00111111)+"mil";
        break;
        default:  
          if(tmpb > 0){
            stat = stat + "On";
          }else{
            stat = stat + "Off";
          }  
        break;
      }

      if(cur_item == 9){
        stat = stat + "]";
      }
      myGLCD.print(stat,0,29);
      
      stat = "Time: ";
      if(cur_item == 10){
        stat = stat + "[";
      }
      bt = EEPROM.read(alertAdr+1)&B00011111;
      if(bt < 10){
        stat = stat + "0";
      }
      stat = stat + (String)bt;
      if(cur_item == 10){
        stat = stat + "]";
      }

      stat = stat + ":";

      if(cur_item == 11){
        stat = stat + "[";
      }
      bt = EEPROM.read(alertAdr+2)&B00111111;
      if(bt < 10){
        stat = stat + "0";
      }
      stat = stat + (String)bt;
      if(cur_item == 11){
        stat = stat + "]";
      }
      myGLCD.print(stat,0,39);

      switch(key){
        case BUTTON_UP:
          if(cur_item_edit){
            if((cur_item == 9)&&(curLoad > 4)){
              bt = EEPROM.read(alertAdr+3);
              //if(bt == 255){
              //  bt = 0;
              //}else
                bt++;
              EEPROM.write(alertAdr+3,bt);
            }
            if(cur_item == 10){
              bt = (EEPROM.read(alertAdr+1)&B00011111);
              if(bt == 23){
                bt = 0;
              }else
                bt++;
              EEPROM.write(alertAdr+1,bt);
            }
            if(cur_item == 11){
              bt = EEPROM.read(alertAdr+2)&B00111111;
              if(bt == 59){
                bt = 0;
              }else
                bt++;
              EEPROM.write(alertAdr+2,bt);
            }
          }else
            if(cur_item == 1){ 
              cur_item = 11;
            }else  
              cur_item--;
        break;
        case BUTTON_DOWN:
          if(cur_item_edit){
            if((cur_item == 9)&&(curLoad > 4)){
              bt = EEPROM.read(alertAdr+3);
              //if(bt == 0){
              //  bt = 255;
              //}else
                bt--;
              EEPROM.write(alertAdr+3,bt);
            }
            if(cur_item == 10){
              bt = EEPROM.read(alertAdr+1)&B00011111;
              if(bt == 0){
                bt = 23;
              }else
                bt--;
              EEPROM.write(alertAdr+1,bt);
            }
            if(cur_item == 11){
              bt = EEPROM.read(alertAdr+2)&B00111111;
              if(bt == 0){
                bt = 59;
              }else
                bt--;
              EEPROM.write(alertAdr+2,bt);
            }
          }else
            if(cur_item == 11){ 
              cur_item = 1;
            }else  
              cur_item++;
        break;
        case BUTTON_OK:
          EEPROM.write(alertAdr+1,(EEPROM.read(alertAdr+1)^(curLoad<<5))); // сохраняем номер нагрузки 
          switch(cur_item){
            case 8:
              EEPROM.write(alertAdr,(EEPROM.read(alertAdr)^B10000000));
            break;
            case 9:
              if(curLoad < 5){
                EEPROM.write(alertAdr+3,(EEPROM.read(alertAdr+3)^B00000001));
              }else{
                cur_item_edit = !cur_item_edit;
              }  
            break;
            case 10:
              cur_item_edit = !cur_item_edit;
            break;
            case 11:
              cur_item_edit = !cur_item_edit;
            break;
            default:
              EEPROM.write(alertAdr,(EEPROM.read(alertAdr)^(1<<(cur_item-1))));
            break;
          }
        break;
         case BUTTON_CANCEL:
          switch(curLoad){
           case 0:
             //CoolTime
             cur_menu = 132;
             cur_item = 2;
           break;
           case 1:
             //"Light1",
             cur_menu = 130;
             cur_item = 1;
           break;
           case 2:
             //"Light2"
             cur_menu = 130;
             cur_item = 2;
           break;
           case 3:
             //"Air"
             cur_menu = 130;
             cur_item = 4;
           break;
           case 4:
             //"CO2"
             cur_menu = 134;
             cur_item = 1;
           break;
           case 5:
             //"LED"
             cur_menu = 130;
             cur_item = 3;
           break;
           case 6:
             //"UDO"
             cur_menu = 134;
             cur_item = 2;
           break;
         }
          cur_item_edit = false;
        break;
      }
      myGLCD.update();
      break;
    }
    case 132: // Termostat -----------------------------------------------------------------
    {
      drawMenu("Termostat", "Aqua T ["+(String)aquaT+"]","CoolTime","minCool","maxCool");
      naviKey(4);
      switch(key){
        case BUTTON_OK:
          switch(cur_item){
            case 1:
              cur_menu = 1321;      
              cur_item = 0;
            break;
            case 2:  //CoolTime
              cur_menu = 133;      
              cur_item = 1;
              menu_off = 1;
              menu_item_count = 8;
              curLoad = 0;
            break;
            case 3:  //minCool // минимальные обороты кулера для вентиляции крышки и охлаждения ламп
              cur_menu = 1323;      
            break;
            case 4:  //maxCool // максимальные обороты для охлаждения воды
              cur_menu = 1324;      
            break;
          }
        break;
        case BUTTON_CANCEL:
          cur_menu = 13;
          cur_item = 2;
          cur_item_edit = false;
        break;
      }
      break;
    }
    case 1321: // Aqua Temperature -----------------------------------------------------------------
    {
      drawIntMenu("Aqua Temperat",18,35,aquaT);
      switch(key){
        case BUTTON_UP:
          aquaT++;
          aquaT = min(aquaT, 35);
        break;
        case BUTTON_DOWN:
          aquaT--;
          aquaT = max(aquaT, 18);
        break;
        case BUTTON_OK:
          EEPROM.write(2,aquaT);                   // Требуемая температура воды
          cur_menu = 132;
          cur_item = 1;
        break;
        case BUTTON_CANCEL:
          aquaT = EEPROM.read(2);                   // Требуемая температура воды
          cur_menu = 132;
          cur_item = 1;
        break;
      }
      break;
    }
    case 1323: // minCool // минимальные обороты кулера для вентиляции крышки и охлаждения ламп ------------------------------------------
    {
      drawIntMenu("minCool",0,maxCool,minCool);
      switch(key){
        case BUTTON_UP:
          minCool++;
          minCool = min(minCool, maxCool);
          analogWrite(EXT_COOLING_PIN, minCool);
        break;
        case BUTTON_DOWN:
          minCool--;
          minCool = max(minCool, 0);
          analogWrite(EXT_COOLING_PIN, minCool);
        break;
        case BUTTON_OK:
          EEPROM.write(3,minCool);                   // минимальные обороты кулера для вентиляции крышки и охлаждения ламп
          cur_menu = 132;
          cur_item = 3;
        break;
        case BUTTON_CANCEL:
          minCool = EEPROM.read(3);                   // минимальные обороты кулера для вентиляции крышки и охлаждения ламп
          cur_menu = 132;
          cur_item = 3;
        break;
      }
      break;
    }
    case 1324: // maxCool // максимальные обороты для охлаждения воды ------------------------------------------
    {
      drawIntMenu("maxCool",0,255,maxCool);
      switch(key){
        case BUTTON_UP:
          maxCool++;
          maxCool = min(maxCool, 255);
          analogWrite(EXT_COOLING_PIN, maxCool);
        break;
        case BUTTON_DOWN:
          maxCool--;
          maxCool = max(maxCool, minCool);
          analogWrite(EXT_COOLING_PIN, maxCool);
        break;
        case BUTTON_OK:
          EEPROM.write(4,maxCool);                   // максимальные обороты для охлаждения воды
          cur_menu = 132;
          cur_item = 4;
        break;
        case BUTTON_CANCEL:
          maxCool = EEPROM.read(4);                   // максимальные обороты для охлаждения воды
          cur_menu = 132;
          cur_item = 4;
        break;
      }
      break;
    }
    case 131: // System -----------------------------------------------------------------
    {
      drawMenu("System", "Time","Date","LED Contrast","LED Light");
      naviKey(4);
      switch(key){
        case BUTTON_OK:
          switch(cur_item){
            case 1:
              cur_menu = 1311;      
              cur_item = 0;
              menu_hh = time.hour;
              menu_mi = time.min;
            break;
            case 2:
              cur_menu = 1312;      
              cur_item = 0;
              menu_dd = time.date;
              menu_mm = time.mon;
              menu_yyyy = time.year;
              menu_dow = time.dow;
            break;
            case 3:
              cur_menu = 1313;      
              cur_item = 0;
            break;
            case 4:
              cur_menu = 1314;      
              cur_item = 0;
            break;
          }
        break;
        case BUTTON_CANCEL:
          cur_menu = 0;
          cur_item = 0;
        break;
      }
      break;
    }
    case 1311: // Time -----------------------------------------------------------------
    {
      myGLCD.setFont(SmallFont);
      myGLCD.clrScr();
  
      myGLCD.print("Time",1,0);
      myGLCD.print(rtc.getTimeStr(FORMAT_SHORT),RIGHT,0);
      myGLCD.drawLine(0,8,83,8);
      myGLCD.drawLine(0,9,83,9);
      if((cur_item == 1)&&cur_item_edit) 
        myGLCD.invertText(true);
      myGLCD.printNumI(menu_hh,26,20,2,'0');
      myGLCD.invertText(false);
      myGLCD.print(":",39,20);
      if((cur_item == 2)&&cur_item_edit) 
        myGLCD.invertText(true);
      myGLCD.printNumI(menu_mi,46,20,2,'0');
      myGLCD.invertText(false);

      if(cur_item == 1)
        myGLCD.drawRoundRect(25,18,39,28);
      if(cur_item == 2)
        myGLCD.drawRoundRect(45,18,59,28);

      switch(key){
        case BUTTON_UP:
          if(!cur_item_edit){ 
            cur_item--;
            if(cur_item < 1)
              cur_item = 2;
          }else{
            if(cur_item == 1){
              menu_hh++;
              if(menu_hh == 24)
                menu_hh = 0;
            }
            if(cur_item == 2){
              menu_mi++;
              if(menu_mi == 60)
                menu_mi = 0;
            }
          }
        break;
        case BUTTON_DOWN:
          if(!cur_item_edit){ 
            cur_item++;
            if(cur_item > 2)
              cur_item = 1;
          }else{
            if(cur_item == 1){
              if(menu_hh == 0)
                menu_hh = 23;
              else  
                menu_hh--;
            }
            if(cur_item == 2){
              if(menu_mi == 0)
                menu_mi = 59;
              else
                menu_mi--;
            }
          }
        break;
        case BUTTON_OK:
          if(cur_item_edit){ 
            switch(cur_item){
              case 1:
                rtc.setTime(menu_hh, time.min, 0);     // Set the time to 12:00:00 (24hr format)
              break;
              case 2:
                rtc.setTime(time.hour, menu_mi, 0);     // Set the time to 12:00:00 (24hr format)
              break;
            }
            cur_item_edit = false;
          }else 
            cur_item_edit = true;
        break;
        case BUTTON_CANCEL:
          cur_item_edit = false;
          cur_menu = 131;      
          cur_item = 1;
        break;
      }
      myGLCD.update();
      break;
    }
    case 1312: // Date -----------------------------------------------------------------
    {
      myGLCD.setFont(SmallFont);
      myGLCD.clrScr();
  
      myGLCD.print("Date",1,0);
      myGLCD.print(rtc.getTimeStr(FORMAT_SHORT),RIGHT,0);
      myGLCD.drawLine(0,8,83,8);
      myGLCD.drawLine(0,9,83,9);

      if((cur_item == 1)&&cur_item_edit) 
        myGLCD.invertText(true);
      myGLCD.printNumI(menu_dd,12,20,2,'0');
      myGLCD.invertText(false);

      myGLCD.print(".",24,20);

      if((cur_item == 2)&&cur_item_edit) 
        myGLCD.invertText(true);
      myGLCD.printNumI(menu_mm,30,20,2,'0');
      myGLCD.invertText(false);

      myGLCD.print(".",42,20);

      if((cur_item == 3)&&cur_item_edit) 
        myGLCD.invertText(true);
      myGLCD.printNumI(menu_yyyy,48,20,4,'0');
      myGLCD.invertText(false);

      myGLCD.print("Day of week",0,32);
      if((cur_item == 4)&&cur_item_edit) 
        myGLCD.invertText(true);
      myGLCD.printNumI(menu_dow,68,32);
      myGLCD.invertText(false);

      switch(cur_item){
        case 1:
          myGLCD.drawRoundRect(11,18,25,28);
        break;  
        case 2:
          myGLCD.drawRoundRect(29,18,44,28);
        break;  
        case 3:
          myGLCD.drawRoundRect(47,18,73,28);
        break;  
        case 4:
          myGLCD.drawRoundRect(67,30,75,40);
        break;  
      }  

      switch(key){
        case BUTTON_UP:
          if(!cur_item_edit){ 
            cur_item--;
            if(cur_item < 1)
              cur_item = 4;
          }else{
            if(cur_item == 1){
              menu_dd++;
              if(menu_dd > 31)
                menu_dd = 1;
            }
            if(cur_item == 2){
              menu_mm++;
              if(menu_mm > 12)
                menu_mm = 1;
            }
            if(cur_item == 3){
              menu_yyyy++;
            }
            if(cur_item == 4){
              menu_dow++;
              if(menu_dow > 7)
                menu_dow = 1;
            }
          }
        break;
        case BUTTON_DOWN:
          if(!cur_item_edit){ 
            cur_item++;
            if(cur_item > 4)
              cur_item = 1;
          }else{
            if(cur_item == 1){
                menu_dd--;
              if(menu_dd < 1)
                menu_dd = 31;
            }
            if(cur_item == 2){
                menu_mm--;
              if(menu_mm < 1)
                menu_mm = 12;
            }
            if(cur_item == 3){
                menu_yyyy--;
                menu_yyyy = max(menu_yyyy,2013);
            }
            if(cur_item == 4){
                menu_dow--;
              if(menu_dow < 1)
                menu_dow = 7;
            }
          }
        break;
        case BUTTON_OK:
          if(cur_item_edit){ 
            switch(cur_item){
              case 1:
                rtc.setDate(menu_dd, time.mon, time.year);   // Set the date
              break;
              case 2:
                rtc.setDate(time.date, menu_mm, time.year);   // Set the date
              break;
              case 3:
                rtc.setDate(time.date, time.mon, menu_yyyy);   // Set the date
              break;
              case 4:
                 rtc.setDOW(menu_dow);     // Set Day-of-Week 
              break;
            }
            cur_item_edit = false;
          }else 
            cur_item_edit = true;
        break;
        case BUTTON_CANCEL:
          cur_item_edit = false;
          cur_menu = 131;      
          cur_item = 2;
        break;
      }
      myGLCD.update();
      break;
    }
    case 1313: // LED Contrast -----------------------------------------------------------------
    {
      drawIntMenu("LED Contrast",45,80,ledContrast);
      switch(key){
        case BUTTON_UP:
          ledContrast++;
          ledContrast = min(ledContrast, 80);
        break;
        case BUTTON_DOWN:
          ledContrast--;
          ledContrast = max(ledContrast, 45);
        break;
        case BUTTON_OK:
          EEPROM.write(0,ledContrast);
          cur_menu = 131;
          cur_item = 3;
        break;
        case BUTTON_CANCEL:
          ledContrast = EEPROM.read(0);
          cur_menu = 131;
          cur_item = 3;
        break;
      }
      myGLCD.setContrast(ledContrast);  
      break;
    }
    case 1314: // LED Light -----------------------------------------------------------------
    {
      drawIntMenu("LED Light",0,255,ledLight);
      switch(key){
        case BUTTON_UP:
          ledLight++;
          ledLight = min(ledLight, 255);
        break;
        case BUTTON_DOWN:
          ledLight--;
          ledLight = max(ledLight, 0);
        break;
        case BUTTON_OK:
          EEPROM.write(1,ledLight);
          cur_menu = 131;
          cur_item = 4;
        break;
        case BUTTON_CANCEL:
          ledLight = EEPROM.read(1);
          cur_menu = 131;
          cur_item = 4;
        break;
      }
      analogWrite(LED_LIGHT_PIN,ledLight);
      break;
    }

    default:
      cur_menu = 0;
      cur_item = 0;
  }
 
//-------ALARM------------------------------------------------------------------------- 
 if(prMin != time.min){
   prMin = time.min;
   for(int a = 100; a < 1001; a = a + 4){
     byte b1 = EEPROM.read(a);
//     if(((boolean)(b1&B10000000))&((boolean)(_BV(time.dow-1)&b1))){  // активная запись и день недели
     if(b1&B10000000){
      if((1<<time.dow-1)&b1){  // активная запись и день недели
       byte b2 = EEPROM.read(a+1);
       if(time.hour == (byte)(b2&B00011111)){        // сравниваем часы
         byte b3 = EEPROM.read(a+2);
         if(time.min == (byte)(b3&B00111111)){        // сравниваем минути
           byte b4 = EEPROM.read(a+3);
           switch((byte)((b2>>5)&B00000111)){         // определяем нагрузку
             case 0:
               // Разрешено ли охлаждение куллером
               if (b4 == 0){
                 CoolingEnabled = false;
                 digitalWrite(EXT_COOLING_PIN, LOW);
               }else{
                 CoolingEnabled = true;
                 analogWrite(EXT_COOLING_PIN, minCool);   // включаем режим проветривания
               }  
             break;
             case 1:  // Light1
               if (b4 == 0){
                 digitalWrite(EXT_LIGHT_1_PIN, LOW);
                 light1 = false;
               }else{
                 digitalWrite(EXT_LIGHT_1_PIN, HIGH);
                 light1 = true;
               }  
             break;   
             case 2:  // Light2
               if (b4 == 0){
                 digitalWrite(EXT_LIGHT_2_PIN, LOW);
                 light2 = false;
               }else{
                 digitalWrite(EXT_LIGHT_2_PIN, HIGH);
                 light2 = true;
               }  
             break;
             case 3:  // Air
               if (b4 == 0){
                 digitalWrite(EXT_AIR_PIN, LOW);
                 air = false;
               }else{
                 digitalWrite(EXT_AIR_PIN, HIGH);
                 air = true;
               }  
             break;
             case 4:  // CO2
               if (b4 == 0){
                 digitalWrite(EXT_CO2_PIN, LOW);
                 CO2 = false;
               }else{
                 digitalWrite(EXT_CO2_PIN, HIGH);
                 CO2 = true;
               }  
             break;
             case 5:  //LED
               // 8 бит 1 восход 0 закат остальные кол мин
               LED_sunrise = b4;
               LED_cur_pos = 0;
             break;
             case 6:  // UDO
               udo_tim = (byte)(b4&B00111111);
               digitalWrite(EXT_POWER_ON_PIN, HIGH);
               delay(100);  //Время на выход в режим БП
               switch((byte)((b4>>6)&B00000011)){
                 case 0:
                   digitalWrite(EXT_UDO_MICRO_PIN, HIGH);
                   delay(udo_tim*4.2);
                   digitalWrite(EXT_UDO_MICRO_PIN, LOW);
                 break;
                 case 1:
                   digitalWrite(EXT_UDO_MACRO_PIN, HIGH);
                   delay(udo_tim*4.2);
                   digitalWrite(EXT_UDO_MACRO_PIN, LOW);
                 break;
                 case 2:
                   digitalWrite(EXT_UDO_Fe_PIN, HIGH);
                   delay(udo_tim*4.2);
                   digitalWrite(EXT_UDO_Fe_PIN, LOW);
                 break;
                 case 3:

                 break;
               }
               digitalWrite(EXT_POWER_ON_PIN, LOW);
             break;
             case 7:
           
             break;
           } 
         }
       }
     }
   }} 
 }
//------------------------------------------------------------------------------------ 
loopTime = currentTime;   
}  
}
