//      3310
#include <LPC213x.h>

//#include <lcd.c>
const char table[480] = {  0x00,0x00,0x00,0x00,0x00,   // 20 space ASCII table for NOKIA LCD: 96 rows * 5 bytes= 480 bytes
                     0x00,0x00,0x5f,0x00,0x00,   // 21 !         Note that this is the same set of codes for character you
                     0x00,0x07,0x00,0x07,0x00,   // 22 "         would find on a HD44780 based character LCD. :)
                     0x14,0x7f,0x14,0x7f,0x14,   // 23 #         Also, given the size of the LCD (84 pixels by 48 pixels),
                     0x24,0x2a,0x7f,0x2a,0x12,   // 24 $         the maximum number of characters per row is only 14. :)
                     0x23,0x13,0x08,0x64,0x62,   // 25 %
                     0x36,0x49,0x55,0x22,0x50,   // 26 &
                     0x00,0x05,0x03,0x00,0x00,   // 27 '
                     0x00,0x1c,0x22,0x41,0x00,   // 28 (
                     0x00,0x41,0x22,0x1c,0x00,   // 29 )
                     0x14,0x08,0x3e,0x08,0x14,   // 2a *
                     0x08,0x08,0x3e,0x08,0x08,   // 2b +
                     0x00,0x50,0x30,0x00,0x00,   // 2c ,
                     0x08,0x08,0x08,0x08,0x08,   // 2d -
                     0x00,0x60,0x60,0x00,0x00,   // 2e .
                     0x20,0x10,0x08,0x04,0x02,   // 2f /
                     0x3e,0x51,0x49,0x45,0x3e,   // 30 0
                     0x00,0x42,0x7f,0x40,0x00,   // 31 1
                     0x42,0x61,0x51,0x49,0x46,   // 32 2
                     0x21,0x41,0x45,0x4b,0x31,   // 33 3
                     0x18,0x14,0x12,0x7f,0x10,   // 34 4
                     0x27,0x45,0x45,0x45,0x39,   // 35 5
                     0x3c,0x4a,0x49,0x49,0x30,   // 36 6
                     0x01,0x71,0x09,0x05,0x03,   // 37 7
                     0x36,0x49,0x49,0x49,0x36,   // 38 8
                     0x06,0x49,0x49,0x29,0x1e,   // 39 9
                     0x00,0x36,0x36,0x00,0x00,   // 3a :
                     0x00,0x56,0x36,0x00,0x00,   // 3b ;
                     0x08,0x14,0x22,0x41,0x00,   // 3c <
                     0x14,0x14,0x14,0x14,0x14,   // 3d =
                     0x00,0x41,0x22,0x14,0x08,   // 3e >
                     0x02,0x01,0x51,0x09,0x06,   // 3f ?
                     0x32,0x49,0x79,0x41,0x3e,   // 40 @
                     0x7e,0x11,0x11,0x11,0x7e,   // 41 A
                     0x7f,0x49,0x49,0x49,0x36,   // 42 B
                     0x3e,0x41,0x41,0x41,0x22,   // 43 C
                     0x7f,0x41,0x41,0x22,0x1c,   // 44 D
                     0x7f,0x49,0x49,0x49,0x41,   // 45 E
                     0x7f,0x09,0x09,0x09,0x01,   // 46 F
                     0x3e,0x41,0x49,0x49,0x7a,   // 47 G
                     0x7f,0x08,0x08,0x08,0x7f,   // 48 H
                     0x00,0x41,0x7f,0x41,0x00,   // 49 I
                     0x20,0x40,0x41,0x3f,0x01,   // 4a J
                     0x7f,0x08,0x14,0x22,0x41,   // 4b K
                     0x7f,0x40,0x40,0x40,0x40,   // 4c L
                     0x7f,0x02,0x0c,0x02,0x7f,   // 4d M
                     0x7f,0x04,0x08,0x10,0x7f,   // 4e N
                     0x3e,0x41,0x41,0x41,0x3e,   // 4f O
                     0x7f,0x09,0x09,0x09,0x06,   // 50 P
                     0x3e,0x41,0x51,0x21,0x5e,   // 51 Q
                     0x7f,0x09,0x19,0x29,0x46,   // 52 R 
					 0x46,0x49,0x49,0x49,0x31,   // 53 S
                     0x01,0x01,0x7f,0x01,0x01,   // 54 T
                     0x3f,0x40,0x40,0x40,0x3f,   // 55 U
                     0x1f,0x20,0x40,0x20,0x1f,   // 56 V
                     0x3f,0x40,0x38,0x40,0x3f,   // 57 W
                     0x63,0x14,0x08,0x14,0x63,   // 58 X
                     0x07,0x08,0x70,0x08,0x07,   // 59 Y
                     0x61,0x51,0x49,0x45,0x43,   // 5a Z
                     0x00,0x7f,0x41,0x41,0x00,   // 5b [
                     0x02,0x04,0x08,0x10,0x20,   // 5c Yen Currency Sign
                     0x00,0x41,0x41,0x7f,0x00,   // 5d ]
                     0x04,0x02,0x01,0x02,0x04,   // 5e ^
                     0x40,0x40,0x40,0x40,0x40,   // 5f _
                     0x00,0x01,0x02,0x04,0x00,   // 60 `
                     0x20,0x54,0x54,0x54,0x78,   // 61 a
                     0x7f,0x48,0x44,0x44,0x38,   // 62 b
                     0x38,0x44,0x44,0x44,0x20,   // 63 c
                     0x38,0x44,0x44,0x48,0x7f,   // 64 d
                     0x38,0x54,0x54,0x54,0x18,   // 65 e
                     0x08,0x7e,0x09,0x01,0x02,   // 66 f
                     0x0c,0x52,0x52,0x52,0x3e,   // 67 g
                     0x7f,0x08,0x04,0x04,0x78,   // 68 h
                     0x00,0x44,0x7d,0x40,0x00,   // 69 i
                     0x20,0x40,0x44,0x3d,0x00,   // 6a j 
                     0x7f,0x10,0x28,0x44,0x00,   // 6b k
                     0x00,0x41,0x7f,0x40,0x00,   // 6c l
                     0x7c,0x04,0x18,0x04,0x78,   // 6d m
                     0x7c,0x08,0x04,0x04,0x78,   // 6e n
                     0x38,0x44,0x44,0x44,0x38,   // 6f o
                     0x7c,0x14,0x14,0x14,0x08,   // 70 p
                     0x08,0x14,0x14,0x18,0x7c,   // 71 q
                     0x7c,0x08,0x04,0x04,0x08,   // 72 r
                     0x48,0x54,0x54,0x54,0x20,   // 73 s
                     0x04,0x3f,0x44,0x40,0x20,   // 74 t
                     0x3c,0x40,0x40,0x20,0x7c,   // 75 u
                     0x1c,0x20,0x40,0x20,0x1c,   // 76 v
                     0x3c,0x40,0x30,0x40,0x3c,   // 77 w
                     0x44,0x28,0x10,0x28,0x44,   // 78 x
                     0x0c,0x50,0x50,0x50,0x3c,   // 79 y
                     0x44,0x64,0x54,0x4c,0x44,   // 7a z
                     0x00,0x08,0x36,0x41,0x00,   // 7b <
                     0x00,0x00,0x7f,0x00,0x00,   // 7c |
                     0x00,0x41,0x36,0x08,0x00,   // 7d >
                     0x10,0x08,0x08,0x10,0x08,   // 7e Right Arrow    ->
                     0x78,0x46,0x41,0x46,0x78};   // 7f Left Arrow   <-


void SCLK (int Level) // / 
{
	if (Level)
		IO1SET = 1<<19;
	else 
		IO1CLR = 1<<19;
}

void SDIN (int Level)  // / 
{
	if (Level)
		IO1SET = 1<<18;
	else 
		IO1CLR = 1<<18;
}

void D_C (int Level)   // / /
{
	if (Level)
		IO1SET = 1<<17;
	else 
		IO1CLR = 1<<17;
}

void RES (int Level)	// / 
{
	if (Level)
		IO1SET = 1<<16;
	else 
		IO1CLR = 1<<16;
}

void clockdata(char bits_in) // 1  +  
{
   int bitcnt;
   for (bitcnt=8; bitcnt>0; bitcnt--)
      {
         SCLK(0);                        
         if ((bits_in & 0x80) == 0x80) SDIN(1);     
         else SDIN(0);
         SCLK(1);                       
         bits_in<<=1;                  

      }
}

void writedata(char data_in)// 1  
{
   D_C(1);            
//   output_low(_SCE);            
   clockdata(data_in);    
//   output_high(_SCE);      
}

void writecom(char command_in)// 1  
{
   D_C(0);            
//   output_low(_SCE);            
   clockdata(command_in);   
//   output_high(_SCE);         
}

void cursorxy(char x, char y)
{
   writecom(0x40 | (y & 0x07));   // Y axis
   writecom(0x80 | (x & 0x7f));   // X axis
}

void clearram(void)  // 
{
   unsigned int ddram;
   cursorxy(0,0);          
   for (ddram=504;ddram>0;ddram--)   writedata(0x00);     // 6*84 = 504 DDRAM addresses.
}

void putchar(char character)
{
unsigned int  count, char_column, tablept;

   if ((character<0x20)||(character>0x7f)) return;      // Exit function if character is not found.

   tablept = ((5*character) - 160);                  // Point to the columns of the character in the table.
   for (count=5;count>0;count--)                     // Draw the columns to print the character.
       {
         char_column = table[tablept];
         writedata(char_column);
         tablept++;
       }
         writedata(0x00);                              // 1 pixel spacing per character.
}

void putstr(char *s)
{
   while(*s) putchar(*s++);                        // Points to one ASCII to be written one at a time.
}

 /*   300  */
void wait()
{
  int d;
  for (d = 0; d < 1000000; d++)
  {
  }
}

void initlcd(void)
{
   RES(1);     
   wait();
//   output_high(_SCE);      // Disable Chip.
   RES(0);    
   
   wait();   // Wait 300ms.
   
   RES(1);      

   writecom(0x21);      // Activate Chip and H=1.
   writecom(0xC2);      // Set LCD Voltage to about 7V.
   writecom(0x13);      // Adjust voltage bias.
   writecom(0x20);      // Horizontal addressing and H=0.
   writecom(0x09);      // Activate all segments.
   clearram();         // Erase all pixel on the DDRAM.
   writecom(0x08);      // Blank the Display.
   writecom(0x0C);      // Display Normal.
   cursorxy(0,0);      // Cursor Home.
}



void main(void)
{
	//   . P1[0] -  */
	IO0DIR = 0x00000001; //P1[0] - 
   	IO0SET=0x00000001; 
	IO1DIR = 0x000f0000; //P1[16]...P1[19] - 

	/*  P1[0].   . 0 */
	IO0CLR = 0x00000001;
	/*  */
	wait();		
	/*  P1[0].   . 1 */
	IO0SET = 0x00000001;
	/*  */
	wait();

	initlcd();
   	cursorxy(0,0);
	putstr("Hello!");      // A test message.... Also a new year's greeting. :)

   	cursorxy(0,1);
	putstr("I am Kobzar!");
}

