#ifndef DS18B20Lib_h
#define DS18B20Lib_h

#include <OneWire.h>

// OneWire commands
#define STARTCONVO      0x44  //   ;
#define READSCRATCH     0xBE  //    ;
#define READPOWERSUPPLY 0xB4  // Determine if device needs parasite power

// Scratchpad locations
#define TEMP_LSB	0
#define TEMP_MSB    1

typedef uint8_t DeviceAddress[8];

class DS18B20Lib {
	private:
		typedef uint8_t ScratchPad[2];
		OneWire* oneWire;
		DeviceAddress deviceAddress;
		int delayTime;
		long millisNow;
		bool ask_sensor;
		long timeWhenAskSensor;
		bool externalSupply;
		bool readPowerSupply(DeviceAddress);
		void readScratchPad(DeviceAddress, uint8_t* scratchPad);
	
	public:
		DS18B20Lib(OneWire*);
		void begin(void);
		bool checkSensorReady();
		void requestTemperatures();
		float getTemperature();
		float getTemperature(DeviceAddress);
};
#endif