#include <OneWire.h>
#include <DS18B20Lib.h>

#define pinDigitalTemperatureAqua1 14
#define pinDigitalTemperatureAqua2 15
#define pinDigitalTemperatureLed1 16
#define pinDigitalTemperatureLed2 17

typedef uint8_t DeviceAddress[8];

OneWire oneWire[] = {
	pinDigitalTemperatureAqua1,
	pinDigitalTemperatureAqua2,
	pinDigitalTemperatureLed1,
	pinDigitalTemperatureLed2
};

DS18B20Lib sensorsTemperature[] = {
	&oneWire[0],
	&oneWire[1],
	&oneWire[2],
	&oneWire[3]
};

const byte sensorTemperatureCount = sizeof(oneWire)/sizeof(OneWire);
float temperature[sensorTemperatureCount];

void setup(void)
{
	Serial.begin(9600);
	for(byte sensor = 0; sensor < sensorTemperatureCount; sensor++){
		sensorsTemperature[sensor].begin();
	}
}

void loop(void){ 
	DisplayTemperatures();
}
void DisplayTemperatures() {
	for(byte sensor = 0; sensor < sensorTemperatureCount; sensor++){
		if (sensorsTemperature[sensor].checkSensorReady()) {
			Serial.println("PrintTemperature");			
			PrintTemperature(sensor);
		}
	}
}

void PrintTemperature(byte sensor) {
	temperature[sensor] = sensorsTemperature[sensor].getTemperature();
	Serial.print(sensor);
	Serial.print(" - ");
	Serial.println(temperature[sensor]);
}