#include "DS18B20Lib.h"


#if ARDUINO >= 100
#include "Arduino.h"
#else
extern "C" {
#include "WConstants.h"
}
#endif

DS18B20Lib::DS18B20Lib(OneWire* _oneWire) {
	oneWire = _oneWire;
	delayTime = 850; 
	timeWhenAskSensor = 0;
	ask_sensor = false;
}

void DS18B20Lib::begin(void){
	if (oneWire->search(deviceAddress)) {
		externalSupply = readPowerSupply(deviceAddress);
	}
}

bool DS18B20Lib::readPowerSupply(DeviceAddress _deviceAddress){
    bool parasite = false;
    oneWire->reset();
    oneWire->select(_deviceAddress);
    oneWire->write(READPOWERSUPPLY);
	parasite = oneWire->read_bit();
    oneWire->reset();
    return parasite;
}

bool DS18B20Lib::checkSensorReady(){
	millisNow = millis();
	if (millisNow < timeWhenAskSensor) {timeWhenAskSensor = millisNow;} // Если таймер перешел через ноль, не даем зависнуть;
	
	if (!ask_sensor) {	// Если не запрашивали температуру с датчика - запросим;
		requestTemperatures();
		ask_sensor = true;					// Подъем флага - температура запрошена!
		timeWhenAskSensor = millisNow;		// Запомним время запроса температуры;
	}
	
	long elapseTime = millisNow-timeWhenAskSensor;
	if (ask_sensor & (elapseTime > delayTime)) {	// Если температура запрошена и прошло более 850 мс	
		ask_sensor = false;		// Сбросили флаг о запросе температуры;
		return true;
	}
	return false;
}

void DS18B20Lib::requestTemperatures(){
    oneWire->reset();
    oneWire->skip();
    oneWire->write(STARTCONVO, externalSupply);
}

float DS18B20Lib::getTemperature(){
	ScratchPad scratchPad;
	readScratchPad(deviceAddress, scratchPad);
	uint8_t highByte, lowByte;
	highByte = scratchPad[TEMP_MSB];
	lowByte = scratchPad[TEMP_LSB];
	float temperature = (float)((highByte << 8) + lowByte)/16.0;
    return temperature;
}

float DS18B20Lib::getTemperature(DeviceAddress _deviceAddress){
	ScratchPad scratchPad;
	readScratchPad(_deviceAddress, scratchPad);
	uint8_t highByte, lowByte;
	highByte = scratchPad[TEMP_MSB];
	lowByte = scratchPad[TEMP_LSB];
	float temperature = (float)((highByte << 8) + lowByte)/16.0;
    return temperature;
}

void DS18B20Lib::readScratchPad(DeviceAddress _deviceAddress,  uint8_t* _scratchPad){
    oneWire->reset();
    oneWire->select(_deviceAddress);
    oneWire->write(READSCRATCH);
    for(byte i = 0; i < 2; i++){
		_scratchPad[i] = oneWire->read();
    }
}