#include <OneWire.h>
#include <DS18B20Lib.h>

#define pinDigitalTemperature 7

typedef uint8_t DeviceAddress[8];

OneWire oneWire(pinDigitalTemperature);
DS18B20Lib sensorsTemperature(&oneWire);

DeviceAddress addresSensorTemperature[] = {
	//{0x28, 0xFF, 0xBE, 0xD9, 0x64, 0x15, 0x02, 0xA3 },
	//{0x28, 0xFF, 0x0D, 0xAD, 0x64, 0x15, 0x03, 0x5A },
    {0x28, 0xFF, 0x01, 0x4C, 0x54, 0x16, 0x04, 0xB5},
	{0x28, 0xFF, 0xE5, 0x6F, 0x53, 0x16, 0x04, 0xF2}
};

const byte sensorTemperatureCount=sizeof(addresSensorTemperature)/sizeof(DeviceAddress);

float temperature[sensorTemperatureCount];

void setup(void)
{
	Serial.begin(9600);
	sensorsTemperature.begin();
}

void loop(void){ 
	DisplayTeTemperatures();
}
void DisplayTeTemperatures() {
	if (sensorsTemperature.checkSensorReady()) {	
		PrintTemperature();
	 }
}

void PrintTemperature() {
	for(int devices = 0; devices < sensorTemperatureCount; devices++){
		temperature[devices] = sensorsTemperature.getTemperature(addresSensorTemperature[devices]);
		Serial.print("End Temp ");
		Serial.print(devices);
		Serial.print(" - ");
		Serial.println(temperature[devices]);
	}
}