#include <Wire.h>
#include <OneWire.h>
#include "RTClib.h"
#include <DS18B20Lib.h>

RTC_DS1307 RTC;
int Hours_Start_Relay34[2] = {11, 12}; // включение реле 3 и 4 час
int Minutes_Start_Relay34[2] = {0, 0}; // включение реле 3 и 4 минута
int Hours_End_Relay34[2] = {20, 21}; // выключение реле 3 и 4 час
int Minutes_End_Relay34[2] = {0, 0}; // выключение реле 3 и 4 минута
int MinuteDay_Start_Relay34[2]; // день в минутах для включения реле 3 и 4
int MinuteDay_End_Relay34[2]; // день в минутах для выключения реле 3 и 4
int Hours_Start_Sunrise[6] = {11, 9, 10, 11, 12, 12}; // начало рассвета по каналам час
int Minutes_Start_Sunrise[6] = {0, 0, 0, 0, 0, 0}; // начало рассвета по каналам минута
int Hours_End_Sunrise[6] = {14, 11, 12, 13, 14, 14}; // окончание рассвета по каналам час
int Minutes_End_Sunrise[6] = {0, 0, 0, 0, 0, 0}; // окончание рассвета по каналам минута
int Hours_Start_Sunset[6] = {18, 21, 20, 19, 18, 18}; // начало заката по каналам час
int Minutes_Start_Sunset[6] = {0, 0, 0, 0, 0, 0}; // начало заката по каналам минута
int Hours_End_Sunset[6] = {21, 22, 22, 21, 21, 21}; // окончание заката по каналам час
int Minutes_End_Sunset[6] = {0, 30, 0, 0, 0, 0}; // окончание заката по каналам минута
int MinuteDay_Start_Sunrise[6]; // день в минутах для начала рассвета
int MinuteDay_End_Sunrise[6]; // день в минутах для окончания рассвета
int MinuteDay_Start_Sunset[6]; // день в минутах для начала заката
int MinuteDay_End_Sunset[6]; // день в минутах для окончания заката
int Current_MinuteDay; // текущая минута суток
int Current_Period[6]; // текущая часть суток 1-рассвет, 2-день, 3-закат, 4-ночь для каждого ШИМ
//int Meridian_PWM[6] = {128, 192, 192, 192, 128, 128}; // максимальное значение ШИМ
int Meridian_PWM[6] = {255, 255, 255, 255, 5, 255}; // максимальное значение ШИМ
int Midnight_PWM[6] = {0, 0, 0, 0, 0, 0}; // минимальное значение ШИМ
int Current_PWM[6] = {0, 0, 0, 0, 0, 0}; // текущее значение ШИМ
/* ************************************************** *** */
/* * * */
/* * ШИМ пин для CW, TV, RB, NB, DR, NG * */
/* * Пин - 3 - CW - Cool White * */
/* * Пин - 5 - TV - True Violet * */
/* * Пин - 6 - RB - Royal Blue * */
/* * Пин - 7 - NB - Blue * */
/* * Пин - 10 - DR - Deep Red * */
/* * Пин - 11 - NG - Green * */
/* * * */
/* ************************************************** *** */
int PWM_Pin[6] = {3, 5, 6, 9, 10, 11}; // ШИМ пин для CW, TV, RB, NB, DR, NG
int Relay1 = 7; //вент
int Relay2 = 8; //луна
// #define pinDigitalLedStrip	3
byte Relay1Status = false;
byte Relay2Status = false;
int Relay34[2] = {4, 12}; //Реле 3 и 4
byte Relay34Status[2] = {false, false};

/********************* Temperature **************************/
#define pinTemperatureAqua 			14
#define pinTemperatureLedRadiator 	15

#define pinRelayHeat 16
#define pinRelayFanWater 17
#define pinRelayFanLedRadiator 2

typedef uint8_t DeviceAddress[8];

OneWire oneWire[] = {
	pinTemperatureAqua,
	pinTemperatureLedRadiator,
};

DS18B20Lib sensorsTemperature[] = {
	&oneWire[0],
	&oneWire[1],
};

const byte sensorTemperatureCount = 2;

float setTemperature[] = {25.0, 50.0};			// Установленная температура: [0] - вода в аквариуме, [1] - радиатор LED;

void setup() {
	Serial.begin(57600);
	Wire.begin();
	RTC.begin();
	SensorsTemperatureBegin();
	if (! RTC.isrunning()) {
		Serial.println("RTC is NOT running!");
		// following line sets the RTC to the date & time this sketch was compiled
		// RTC.adjust(DateTime(2013, 1, 1, 12, 59, 1));
	}

	for (int i=0; i<6; i++){
		pinMode(PWM_Pin[i], OUTPUT); // Установка пин для ШИМ
	}
	
	for (int i=0; i<6; i++) {
		analogWrite(PWM_Pin[i], Midnight_PWM[i]); // Установка минимального значения ШИМ
		Current_PWM[i]=Midnight_PWM[i]; // установка текущих значений ШИМ в минимум
	}
	
	for (int i=0; i<6; i++){
		MinuteDay_Start_Sunrise[i]=60*Hours_Start_Sunrise[i] + Minutes_Start_Sunrise[i]; // Расчет минуты суток для начала рассвета
		MinuteDay_End_Sunrise[i]=60*Hours_End_Sunrise[i] + Minutes_End_Sunrise[i]; // Расчет минуты суток для окончания рассвета
		MinuteDay_Start_Sunset[i]=60*Hours_Start_Sunset[i] + Minutes_Start_Sunset[i]; // Расчет минуты суток для начала заката
		MinuteDay_End_Sunset[i]=60*Hours_End_Sunset[i] + Minutes_End_Sunset[i]; // Расчет минуты суток для окончания заката
	}
	
	for (int i=0; i<2; i++){
		MinuteDay_Start_Relay34[i]=60*Hours_Start_Relay34[i] + Minutes_Start_Relay34[i]; // Расчет минуты суток для включения реле 3 и 4
		MinuteDay_End_Relay34[i]=60*Hours_End_Relay34[i] + Minutes_End_Relay34[i]; // Расчет минуты суток для выключения реле 3 и 4
		pinMode(Relay34[i], OUTPUT);
		digitalWrite(Relay34[i], LOW);
	}
	
	pinMode(Relay1, OUTPUT);
	pinMode(Relay2, OUTPUT);
	digitalWrite(Relay1, LOW);
	digitalWrite(Relay2, HIGH);
	pinMode(pinRelayHeat, OUTPUT);
	pinMode(pinRelayFanWater, OUTPUT);
	pinMode(pinRelayFanLedRadiator, OUTPUT);
}

// Процедура расчета текущего периода и значения PWM по каналам
void Led_Dim_PWM(){
	DateTime now = RTC.now();
	Current_MinuteDay = (now.hour() * 60) + now.minute();

	for (int i=0; i<6; i++){
		Current_Period[i]=4;
		if (Current_MinuteDay>=MinuteDay_Start_Sunrise[i] && Current_MinuteDay<=MinuteDay_End_Sunrise[i]) {
			Current_Period[i]=1;
		}
		if (Current_MinuteDay>MinuteDay_End_Sunrise[i] && Current_MinuteDay<MinuteDay_Start_Sunset[i]) {
			Current_Period[i]=2;
		}
		if (Current_MinuteDay>=MinuteDay_Start_Sunset[i] && Current_MinuteDay<=MinuteDay_End_Sunset[i]) {
			Current_Period[i]=3;
		}
		if (Current_Period[i]==1){
			Current_PWM[i]=(float)(((float)Current_MinuteDay-MinuteDay_Start_Sunrise[i])/((float)MinuteDay_End_Sunrise[i]-MinuteDay_Start_Sunrise[i]))*((float)Meridian_PWM[i]-Midnight_PWM[i]);
			if (Current_PWM[i]<Midnight_PWM[i]){
				Current_PWM[i]=Midnight_PWM[i];
				}
			analogWrite(PWM_Pin[i], Current_PWM[i]);
		}
		if (Current_Period[i]==2){
			if (Current_PWM[i]!=Meridian_PWM[i]){
				Current_PWM[i]=Meridian_PWM[i];
				analogWrite(PWM_Pin[i], Current_PWM[i]);
			}
		}
		if (Current_Period[i]==3){
			Current_PWM[i]=(float)(((float)MinuteDay_End_Sunset[i]-Current_MinuteDay)/((float)MinuteDay_End_Sunset[i]-MinuteDay_Start_Sunset[i]))*((float)Meridian_PWM[i]-Midnight_PWM[i]);
			analogWrite(PWM_Pin[i], Current_PWM[i]);
		}

		if (Current_Period[i]==4){
			if (Current_PWM[i]!=Midnight_PWM[i]){
				Current_PWM[i]=Midnight_PWM[i];
				if (Current_PWM[i]<Midnight_PWM[i]){
					Current_PWM[i]=Midnight_PWM[i];
				}
				analogWrite(PWM_Pin[i], Current_PWM[i]);
			}
		}
	}
Serial.print(now.year(), DEC);
Serial.print('/');
Serial.print(now.month(), DEC);
Serial.print('/');
Serial.print(now.day(), DEC);
Serial.print(' ');
Serial.print(now.hour(), DEC);
Serial.print(':');
Serial.print(now.minute(), DEC);
Serial.print(':');
Serial.print(now.second(), DEC);
Serial.print(" Current_MinuteDay: ");
Serial.print(Current_MinuteDay, DEC);
Serial.println();

	for (int i=0; i<=5; i++){
		Serial.print("Channel #");
		Serial.print(i, DEC);
		// Serial.println();
		Serial.print(", Current Period: ");
		if (Current_Period[i]==1) {Serial.print("Sunrise");}
		if (Current_Period[i]==2) {Serial.print("Meridian");}
		if (Current_Period[i]==3) {Serial.print("Sunset");}
		if (Current_Period[i]==4) {Serial.print("Midnight");}
		Serial.print(", Current PWM: ");
		Serial.print(Current_PWM[i], DEC);
		Serial.println();
	}
	Serial.println();
}

void RalayOnOff(){
	int SumPWM=0;
	for (int i=0; i<=5; i++){
		SumPWM=SumPWM+Current_PWM[i];
	}
	if (SumPWM>=50 && Relay1Status==false){
		Relay1Status=true;
		Relay2Status=false;
		digitalWrite(Relay1, HIGH);
		digitalWrite(Relay2, LOW);
	}
	if (SumPWM<50 && Relay1Status==true){
		Relay1Status=false;
		Relay2Status=true;
		digitalWrite(Relay1, LOW);
		digitalWrite(Relay2, HIGH);
	}
}

void Ralay34OnOff(){
	for (int i=0; i<=1; i++){
		if (Current_MinuteDay>=MinuteDay_Start_Relay34[i] && Current_MinuteDay<=MinuteDay_End_Relay34[i]){
			if (Relay34Status[i]==false){
				Relay34Status[i]=true;
				digitalWrite(Relay34[i], HIGH);
			}
		}
		if (Current_MinuteDay<MinuteDay_Start_Relay34[i] || Current_MinuteDay>MinuteDay_End_Relay34[i]){
			if (Relay34Status[i]==true){
				Relay34Status[i]=false;
				digitalWrite(Relay34[i], LOW);
			}
		}
	}
}

void loop(){
	if ( ( millis() % 30000 ) == 0 ){
		Led_Dim_PWM();
		RalayOnOff();
		Ralay34OnOff();
		ControlTemperature();
	}
}


void SensorsTemperatureBegin(){
	for(byte sensor = 0; sensor < sensorTemperatureCount; sensor++){
		sensorsTemperature[sensor].begin();
	}
}

void ControlTemperature() { 
	for(byte sensor = 0; sensor < sensorTemperatureCount; sensor++){
		if (sensorsTemperature[sensor].checkSensorReady()) {			
			GetTemperature();
		}
	}
}

float currentTemperature[sensorTemperatureCount];

void GetTemperature() {
	for(int sensor = 0; sensor < sensorTemperatureCount; sensor++){
		currentTemperature[sensor] = sensorsTemperature[sensor].getTemperature();
		Serial.print(sensor);
		Serial.print(" - ");
		Serial.println(currentTemperature[sensor]);
	}
	CorrectionTemperature();
}


float hysteresis = 1.0;
float hysteresisFan = 2.0;

void CorrectionTemperature() {
	if(currentTemperature[0] > (setTemperature[0]-hysteresis)) {	// 25 - 1 = 24 Heat on
		digitalWrite(pinRelayHeat, HIGH);
	}
	
	if(currentTemperature[0] < (setTemperature[0]+hysteresis)) {	// 25 + 1 = 26 Heat off
		digitalWrite(pinRelayHeat, LOW);
	}
	
	if(currentTemperature[0] > (setTemperature[0]+hysteresisFan)) {	// 25 + 2 = 27 Fan on
		digitalWrite(pinRelayFanWater, HIGH);
	}
	
	if(currentTemperature[0] < (setTemperature[0]+hysteresis)) {	// 25  + 1 = 26 Fan off
		digitalWrite(pinRelayFanWater, LOW);
	}
	
	if(currentTemperature[1] < (setTemperature[1]-hysteresis)) {	// 50 - 1 = 49 FanLed off
		digitalWrite(pinRelayFanLedRadiator, LOW);
	}
	
	if(currentTemperature[1] < (setTemperature[1]+hysteresis)) {	// 50 + 1 = 51 FanLed on
		digitalWrite(pinRelayFanLedRadiator, HIGH);
	}
}